$( document ).ready(function() {

    af2_builder_object.af2_save_object.name = af2_builder_object.af2_save_object.name != null ? af2_builder_object.af2_save_object.name : '';
    af2_builder_object.af2_save_object.description = af2_builder_object.af2_save_object.description != null ? af2_builder_object.af2_save_object.description : '';
    af2_builder_object.af2_save_object.tracking_code = af2_builder_object.af2_save_object.tracking_code != null ? af2_builder_object.af2_save_object.tracking_code : '';

    const af2FragenbuilderBuildDropdownPreset = (editcontentarrayid) => {
        let preset = '';
        preset += '<div class="af2_dropdown_element_wrapper af2_builder_editable_object af2_builder_deletable_object" data-deletetriggerid="af2_dropdown_element_container" data-saveobjectid="dropdown_options" data-editcontentid="dropdown" data-editcontentarrayid="'+editcontentarrayid+'">';
            preset += '<span class="af2_delete_object"><i class="fas fa-trash"></i></span>';
            preset += '<div id="af2_dropdown_element" class="af2_dropdown_element" data-editcontentarrayid="'+editcontentarrayid+'">';
            preset += '</div>';
        preset += '</div>';

        return preset;
    }

    const af2FragenbuilderBuildDropdownPresets = () => {
        let presets = '';
        af2_builder_object.af2_save_object.dropdown_options.forEach((element, index) => {
            presets += af2FragenbuilderBuildDropdownPreset(index);
        });

        return presets;
    }

    const af2FragenbuilderBuildAnswerPreset = (editcontentarrayid) => {
        let preset = '';
        preset += '<div class="af2_answer_wrapper af2_builder_editable_object af2_builder_deletable_object af2_array_draggable" data-deletetriggerid="af2_answers_container" data-saveobjectid="answers" data-editcontentid="answer" data-editcontentarrayid="'+editcontentarrayid+'">';
            preset += '<span class="af2_delete_object"><i class="fas fa-trash"></i></span>';
            preset += '<div id="af2_answer_img" class="af2_answer_img" data-editcontentarrayid="'+editcontentarrayid+'">';
            preset += '</div>';
            preset += '<div class="af2_answer_text_wrapper"><div id="af2_answer_text" class="af2_answer_text" data-editcontentarrayid="'+editcontentarrayid+'"></div></div>';
        preset += '</div>';

        return preset;
    }

    const af2FragenbuilderBuildAnswerPresets = () => {
        let presets = '';
        af2_builder_object.af2_save_object.answers.forEach((element, index) => {
            presets += af2FragenbuilderBuildAnswerPreset(index);
        });

        return presets;
    }


    /*
    * Object Manipulation (after load - and select)
    * Check that EVERYTHING IS THERE WE NEED
    */
    const af2_switch_type_builder_manipulation = (type) => {
        const af2_valuable = af2_builder_object.af2_save_object.af2_valuable;
        const description = af2_builder_object.af2_save_object.description;
        const name = af2_builder_object.af2_save_object.name;
        const tracking_code = af2_builder_object.af2_save_object.tracking_code;
        const typ = af2_builder_object.af2_save_object.typ;

        // Af2 Select - Multiselect
        const answers = af2_builder_object.af2_save_object.answers;
        const desktop_layout = af2_builder_object.af2_save_object.desktop_layout;
        const mobile_layout = af2_builder_object.af2_save_object.mobile_layout;
        const condition = af2_builder_object.af2_save_object.condition;

        // Textfeld - Textbereich attributes
        const textfeld = af2_builder_object.af2_save_object.textfeld;
        const textfield_mandatory = af2_builder_object.af2_save_object.textfield_mandatory;
        const textarea = af2_builder_object.af2_save_object.textarea;
        const textarea_mandatory = af2_builder_object.af2_save_object.textarea_mandatory;
        const min_length = af2_builder_object.af2_save_object.min_length;
        const max_length = af2_builder_object.af2_save_object.max_length;
        const text_only_text = af2_builder_object.af2_save_object.text_only_text;
        const text_only_numbers = af2_builder_object.af2_save_object.text_only_numbers;
        const text_birthday = af2_builder_object.af2_save_object.text_birthday;

        // Datum
        const datum = af2_builder_object.af2_save_object.datum;
        const datum_format = af2_builder_object.af2_save_object.datum_format;
        const datemandatory = af2_builder_object.af2_save_object.datemandatory;

        // Dateiupload
        const fileupload_desc = af2_builder_object.af2_save_object.fileupload_desc;
        const fileupload_max_size = af2_builder_object.af2_save_object.fileupload_max_size;
        const fileupload_max_count = af2_builder_object.af2_save_object.fileupload_max_count;
        const fileupload_mandatory = af2_builder_object.af2_save_object.fileupload_mandatory;
        const restrictedFiles = af2_builder_object.af2_save_object.restrictedFiles;

        // HTML
        const content_area = af2_builder_object.af2_save_object.content_area;
        const content_wait = af2_builder_object.af2_save_object.content_wait;
        const content_button = af2_builder_object.af2_save_object.content_button;
        const content_button_text = af2_builder_object.af2_save_object.content_button_text;

        // Slider
        const label = af2_builder_object.af2_save_object.label;
        const lab = af2_builder_object.af2_save_object.lab;
        const min = af2_builder_object.af2_save_object.min;
        const max = af2_builder_object.af2_save_object.max;
        const step = af2_builder_object.af2_save_object.step;
        const start = af2_builder_object.af2_save_object.start;
        const text_manual = af2_builder_object.af2_save_object.text_manual;
        const thousand = af2_builder_object.af2_save_object.thousand;
        const manual = af2_builder_object.af2_save_object.manual;
        const slider_image = af2_builder_object.af2_save_object.slider_image;

        // Terminbuchung
        const terminbuchungsid = af2_builder_object.af2_save_object.terminbuchungsid;

        // dropdown
        const dropdown_options = af2_builder_object.af2_save_object.dropdown_options;

        // AddressField
        const zoomlevel = af2_builder_object.af2_save_object.zoomlevel;
        const startposition = af2_builder_object.af2_save_object.startposition;
        const mapmandatory = af2_builder_object.af2_save_object.mapmandatory;
        


        af2_builder_object.af2_save_object = {};

        af2_builder_object.af2_save_object.af2_valuable = af2_valuable;
        af2_builder_object.af2_save_object.description = description;
        af2_builder_object.af2_save_object.name = name;
        af2_builder_object.af2_save_object.typ = typ;
        af2_builder_object.af2_save_object.tracking_code = tracking_code;

        const heading_elements = af2_builder_object.sidebar_elements.find(element => element.editContentId == 'heading');
        const layout_elements = heading_elements.fields.filter(element => element.type == 'radio');
        const desktop_layout_el = layout_elements.find(element => element.details.saveObjectId == 'desktop_layout');
        const mobile_layout_el = layout_elements.find(element => element.details.saveObjectId == 'mobile_layout');

        const datum_format_elements = af2_builder_object.sidebar_elements.find(element => element.editContentId == 'date');
        const df_select_elements = datum_format_elements.fields.filter(element => element.type == 'select');
        const datum_format_el = df_select_elements.find(element => element.details.saveObjectId == 'datum_format');

        layout_elements.forEach(element => element.enabled = false);


        switch(type) {
            case 'af2_select': {
                layout_elements.forEach(element => element.enabled = true);
                af2_builder_object.af2_save_object.desktop_layout = desktop_layout != undefined && desktop_layout != null ? desktop_layout : desktop_layout_el.default_option;
                af2_builder_object.af2_save_object.mobile_layout = mobile_layout != undefined && mobile_layout != null ? mobile_layout : mobile_layout_el.default_option;
                af2_builder_object.af2_save_object.answers = answers != null && answers != '' ? answers : [{"text":af2_fragenbuilder_object.strings.antwort, "img":"fas fa-atom"}, {"text": af2_fragenbuilder_object.strings.antwort, "img":"fas fa-atom"}];
                $('.af2_answers_container').prepend(af2FragenbuilderBuildAnswerPresets()); // add Answers
                break;
            }
            case 'af2_multiselect': {
                layout_elements.forEach(element => element.enabled = true);
                af2_builder_object.af2_save_object.desktop_layout = desktop_layout != undefined && desktop_layout != null ? desktop_layout : desktop_layout_el.default_option;
                af2_builder_object.af2_save_object.mobile_layout = mobile_layout != undefined && mobile_layout != null ? mobile_layout : mobile_layout_el.default_option;
                af2_builder_object.af2_save_object.answers = answers != null && answers != '' ? answers : [{"text":af2_fragenbuilder_object.strings.antwort, "img":"fas fa-atom"}, {"text": af2_fragenbuilder_object.strings.antwort, "img":"fas fa-atom"}];
                af2_builder_object.af2_save_object.condition = condition != null && condition.trim() != '' ? condition : null;
                $('.af2_answers_container').prepend(af2FragenbuilderBuildAnswerPresets()); // add Answers
                break;
            }
            case 'af2_textfeld': {
                af2_builder_object.af2_save_object.textfeld = textfeld != undefined ? textfeld : textarea != undefined ? textarea : '';
                af2_builder_object.af2_save_object.min_length = min_length != undefined ? min_length : null;
                af2_builder_object.af2_save_object.max_length = max_length != undefined ? max_length : null;
                af2_builder_object.af2_save_object.text_only_text = text_only_text != undefined ? text_only_text : false;
                af2_builder_object.af2_save_object.text_only_numbers = text_only_numbers != undefined ? text_only_numbers : false;
                af2_builder_object.af2_save_object.text_birthday = text_birthday != undefined ? text_birthday : false;
                af2_builder_object.af2_save_object.textfield_mandatory = textfield_mandatory != undefined ? textfield_mandatory : textarea_mandatory != undefined ? textarea_mandatory : false;
                break;
            }
            case 'af2_textbereich': {
                af2_builder_object.af2_save_object.textarea = textfeld != undefined ? textfeld : textarea != undefined ? textarea : '';
                af2_builder_object.af2_save_object.min_length = min_length != undefined ? min_length : null;
                af2_builder_object.af2_save_object.max_length = max_length != undefined ? max_length : null;
                af2_builder_object.af2_save_object.text_only_text = text_only_text != undefined ? text_only_text : false;
                af2_builder_object.af2_save_object.text_only_numbers = text_only_numbers != undefined ? text_only_numbers : false;
                af2_builder_object.af2_save_object.text_birthday = text_birthday != undefined ? text_birthday : false;
                af2_builder_object.af2_save_object.textarea_mandatory = textfield_mandatory != undefined ? textfield_mandatory : textarea_mandatory != undefined ? textarea_mandatory : false;
                break;
            }
            case 'af2_datum': {
                af2_builder_object.af2_save_object.datum = datum != undefined ? datum : '';
                af2_builder_object.af2_save_object.datum_format = datum_format != undefined ? datum_format : datum_format_el.default_value;
                af2_builder_object.af2_save_object.datemandatory = datemandatory != undefined ? datemandatory : false;
                break;
            }
            case 'af2_dateiupload': {
                af2_builder_object.af2_save_object.fileupload_desc = fileupload_desc != undefined ? fileupload_desc : af2_fragenbuilder_object.strings.upload;
                af2_builder_object.af2_save_object.fileupload_mandatory = fileupload_mandatory != undefined ? fileupload_mandatory : false;
                af2_builder_object.af2_save_object.fileupload_max_size = fileupload_max_size != undefined ? fileupload_max_size : '';
                af2_builder_object.af2_save_object.fileupload_max_count = fileupload_max_count != undefined ? fileupload_max_count : '';
                af2_builder_object.af2_save_object.restrictedFiles = restrictedFiles != undefined ? restrictedFiles : [];
                break;
            }
            case 'af2_slider': {
                af2_builder_object.af2_save_object.label = label != undefined ? label : null;
                af2_builder_object.af2_save_object.min = min != undefined ? min : null;
                af2_builder_object.af2_save_object.max = max != undefined ? max : null;
                af2_builder_object.af2_save_object.step = step != undefined ? step : null;
                af2_builder_object.af2_save_object.start = start != undefined ? start : null;
                af2_builder_object.af2_save_object.text_manual = text_manual != undefined ? text_manual : null;
                af2_builder_object.af2_save_object.thousand = thousand != undefined ? thousand : true;
                af2_builder_object.af2_save_object.manual = manual != undefined ? manual : false;
                af2_builder_object.af2_save_object.lab = lab != undefined ? lab : false;
                af2_builder_object.af2_save_object.slider_image = slider_image != undefined ? slider_image : null;
                break;
            }
            case 'af2_content': {
                af2_builder_object.af2_save_object.content_area = content_area != undefined ? content_area : '';
                af2_builder_object.af2_save_object.content_wait = content_wait != undefined ? content_wait : null;
                af2_builder_object.af2_save_object.content_button = content_button != undefined ? content_button : false;
                af2_builder_object.af2_save_object.content_button_text = content_button_text != undefined ? content_button_text : '';
                break;
            }
            case 'af2_terminbuchung': {
                af2_builder_object.af2_save_object.terminbuchungsid = terminbuchungsid != undefined ? terminbuchungsid : null;
                break;
            }
            case 'af2_dropdown': {
                af2_builder_object.af2_save_object.dropdown_options = dropdown_options != null && dropdown_options != '' ? dropdown_options : [{"label":af2_fragenbuilder_object.strings.antwort, "value":"0"}, {"label": af2_fragenbuilder_object.strings.antwort, "value":"1"}];
                $('.af2_dropdown_element_container').prepend(af2FragenbuilderBuildDropdownPresets()); // add Answers
                break;
            }
            case 'af2_adressfeld': {
                af2_builder_object.af2_save_object.zoomlevel = zoomlevel != undefined ? zoomlevel : '8';
                af2_builder_object.af2_save_object.startposition = startposition != undefined ? startposition : {name: af2_fragenbuilder_object.strings.start_position, 'loc': {lat: af2_fragenbuilder_object.strings.start_lat, lng: af2_fragenbuilder_object.strings.start_lng}};
                af2_builder_object.af2_save_object.mapmandatory = mapmandatory != undefined ? mapmandatory : false;

                if (typeof google === 'object' && typeof google.maps === 'object') {
                    window.af2_fragenInitAdresss();
                } else {
                    let script = document.createElement('script');
                    script.src = 'https://maps.googleapis.com/maps/api/js?key='+af2_fragenbuilder_object.supported_server_size+'&callback=af2_fragenInitAdresss&libraries=places';
                    script.async = true;
                    document.head.appendChild(script);
                }
                break;
            }
        }
    }

    window.af2_fragenInitAdresss = () => {
        const saveObject = af2_builder_object.af2_save_object;
        const cent = saveObject.startposition.loc.lat == undefined && saveObject.startposition.loc.lng == undefined ? { lat: 51.165691, lng: 10.451526 } : { lat: parseFloat(saveObject.startposition.loc.lat), lng: parseFloat(saveObject.startposition.loc.lng) };
        map = new google.maps.Map(document.getElementById('af2_backend_map'), {
            center: cent,
            zoom: parseInt(af2_builder_object.af2_save_object.zoomlevel),
            mapTypeId: "roadmap",
            mapTypeControlOptions: { mapTypeIds: [] },
            disableDefaultUI: true,
        });
        window.googleMapObject = map;
    }

    // Load the Object Data
    if(af2_builder_object.af2_save_object['typ'] != null) {
        $('.af2_builder_sidebar_element[data-elementid="'+af2_builder_object.af2_save_object['typ']+'"]').addClass('selected');


        $('.af2_question_type_wrapper_custom_content').html(af2_fragenbuilder_object.question_types[af2_builder_object.af2_save_object['typ']]);
        
        af2_switch_type_builder_manipulation(af2_builder_object.af2_save_object['typ']);
        //af2_load_object_data();
    }
        
    // Choosing Sidebar element
    $('.af2_builder_sidebar_element').on('click', function() {
        $('.af2_builder_sidebar_element.selected').removeClass('selected');
        
        $(this).addClass('selected');
        const elementId = $(this).data('elementid');
        
        $('.af2_question_type_wrapper_custom_content').html(af2_fragenbuilder_object.question_types[elementId]);
        af2_builder_object.af2_save_object['typ'] = elementId;

        af2_switch_type_builder_manipulation(af2_builder_object.af2_save_object['typ']);
        af2_load_object_data();
    });

    // Add Answer
    $(document).on('click', '#af2_answer_wrapper_add', _ => {
        af2_builder_object.af2_save_object.answers.push({"text":af2_fragenbuilder_object.strings.antwort, "img":"fas fa-atom"});
        $('.af2_answers_container').find('.af2_answer_wrapper').remove();
        $('.af2_answers_container').prepend(af2FragenbuilderBuildAnswerPresets());

        const dataHandler = af2_builder_object.sidebar_elements.find(element => element.editContentId == 'answer');
        dataHandler.fields.forEach(field => af2_load_field_html_data(dataHandler, field));
    });
    // Add Answer
    $(document).on('click', '#af2_dropdown_wrapper_add', e => {
        e.stopPropagation();
        af2_builder_object.af2_save_object.dropdown_options.push({"label":af2_fragenbuilder_object.strings.antwort, "value":af2_builder_object.af2_save_object.dropdown_options.length.toString()});
        $('.af2_dropdown_element_container').find('.af2_dropdown_element_wrapper').remove();
        $('.af2_dropdown_element_container').prepend(af2FragenbuilderBuildDropdownPresets());

        const dataHandler = af2_builder_object.sidebar_elements.find(element => element.editContentId == 'dropdown');
        dataHandler.fields.forEach(field => af2_load_field_html_data(dataHandler, field));
    });



    af2_load_object_data();
    af2_load_input_html_data();

    const unsommonSidebarByFragenbuilder = () => {
        $('.af2_builder_editable_object.selected').removeClass('selected');

        const handler = $('.af2_builder_sidebar.editSidebar');

        handler.one('webkitTransitionEnd otransitionend oTransitionEnd msTransitionEnd transitionend', _ => {
            $('.editSidebar .af2_builder_sidebar_content_wrapper').html();
        });
        handler.addClass('hide');
        $('.af2_builder_content').removeClass('no_margin');
    }
    
    // On Delete function
    $(document).on('af2_deleted_deleteable_object', '.af2_answers_container', _ => {
        $('.af2_answers_container').find('.af2_answer_wrapper').not('.af2_dragging').remove();
        $('.af2_answers_container').prepend(af2FragenbuilderBuildAnswerPresets());
        const dataHandler = af2_builder_object.sidebar_elements.find(element => element.editContentId == 'answer');
        dataHandler.fields.forEach(field => af2_load_field_html_data(dataHandler, field));
        unsommonSidebarByFragenbuilder();
    });
    // On Delete function
    $(document).on('af2_deleted_deleteable_object', '.af2_dropdown_element_container', _ => {
        $('.af2_dropdown_element_container').find('.af2_dropdown_element_wrapper').remove();
        $('.af2_dropdown_element_container').prepend(af2FragenbuilderBuildDropdownPresets());
        const dataHandler = af2_builder_object.sidebar_elements.find(element => element.editContentId == 'dropdown');
        dataHandler.fields.forEach(field => af2_load_field_html_data(dataHandler, field));
        unsommonSidebarByFragenbuilder();
    });

    // On Drag function
    $(document).on('af2_draggin_dragable_object', '.af2_answers_container', _ => {
        $('.af2_answers_container').find('.af2_answer_wrapper').not('.af2_dragging').remove();
        $('.af2_answers_container').prepend(af2FragenbuilderBuildAnswerPresets());
        const dataHandler = af2_builder_object.sidebar_elements.find(element => element.editContentId == 'answer');
        dataHandler.fields.forEach(field => af2_load_field_html_data(dataHandler, field));

        const selContainer = $('.af2_answers_container');
        const selElement = $('.af2_answers_container').find('.af2_answer_wrapper').not('.af2_dragging');
        af2_create_array_dropzones_in(selContainer, selElement, 'af2_answer_dropzone');
    });
    $(document).on('af2_dropped_dragable_object', '.af2_answers_container', _ => {
        $('.af2_answers_container').find('.af2_answer_wrapper').remove();
        $('.af2_answers_container').find('.af2_array_dropzone_in').remove();
        $('.af2_answers_container').prepend(af2FragenbuilderBuildAnswerPresets());
        const dataHandler = af2_builder_object.sidebar_elements.find(element => element.editContentId == 'answer');
        dataHandler.fields.forEach(field => af2_load_field_html_data(dataHandler, field));
    });




    $(document).on('set_move_button', '#af2_html', ev => {
        const value = af2_builder_object.af2_save_object['content_button'];

        if(value == true || value == 'true') $('#af2_html_button_wrapper').removeClass('af2_hide');
        else $('#af2_html_button_wrapper').addClass('af2_hide');
    });

    $(document).on('af2_slider_enable_manual', '#af2_slider_wrapper', ev => {
        const value = af2_builder_object.af2_save_object['manual'];

        const slider_element = af2_builder_object.sidebar_elements.find(element => element.editContentId == 'slider');
        const text_manual_element = slider_element.fields.find(element => element.details.saveObjectId == 'text_manual');

        if(value == true || value == 'true') {
            $('#af2_slider_alternate_input').removeClass('af2_hide');
        } 
        else { 
            $('#af2_slider_alternate_input').addClass('af2_hide');
        }
    });

    const af2_calculate_dots = () => {
        if(af2_builder_object.af2_save_object.thousand == false || af2_builder_object.af2_save_object.thousand == 'false') {
            let min = af2_builder_object.af2_save_object.min;
            let max = af2_builder_object.af2_save_object.max;
            let start = af2_builder_object.af2_save_object.start;

            $('#af2_slider_value_min').html(min);
            $('#af2_slider_value_max').html(max);
            $('#af2_slider_start_value').html(start);
        }
        else {
            let min = af2_builder_object.af2_save_object.min;
            let max = af2_builder_object.af2_save_object.max;
            let start = af2_builder_object.af2_save_object.start;

            if(parseInt(min) != NaN && min != null) {
                min = min.toString().replace(/\B(?=(\d{3})+(?!\d))/g, af2_fragenbuilder_object.strings.dot);
            }
            if(parseInt(max) != NaN && max != null) {
                max = max.toString().replace(/\B(?=(\d{3})+(?!\d))/g, af2_fragenbuilder_object.strings.dot);
            }
            if(parseInt(start) != NaN && start != null) {
                start = start.toString().replace(/\B(?=(\d{3})+(?!\d))/g, af2_fragenbuilder_object.strings.dot);
            }

            $('#af2_slider_value_min').html(min);
            $('#af2_slider_value_max').html(max);
            $('#af2_slider_start_value').html(start);
        }
    }

    const af2_calc_label = () => {
        $('.af2_slider_label').remove();
        if(af2_builder_object.af2_save_object.label == null) return;
        if(af2_builder_object.af2_save_object.lab == false || af2_builder_object.af2_save_object.lab == 'false') {
            $('.af2_slider_min').append('<h4 class="af2_slider_label">'+af2_builder_object.af2_save_object.label+'</h4>');
            $('.af2_slider_max').append('<h4 class="af2_slider_label">'+af2_builder_object.af2_save_object.label+'</h4>');
            $('.af2_slider_start').append('<h3 class="af2_slider_label">'+af2_builder_object.af2_save_object.label+'</h3>');
        }
        else {
            $('.af2_slider_min').prepend('<h4 class="af2_slider_label">'+af2_builder_object.af2_save_object.label+'</h4>');
            $('.af2_slider_max').prepend('<h4 class="af2_slider_label">'+af2_builder_object.af2_save_object.label+'</h4>');
            $('.af2_slider_start').prepend('<h3 class="af2_slider_label">'+af2_builder_object.af2_save_object.label+'</h3>');
        }
    }

    $(document).on('af2_calculate_dots', '#af2_slider_wrapper', function() { af2_calculate_dots(); });
    $(document).on('af2_calculate_dots', '#af2_slider_value_min', function() { af2_calculate_dots(); });
    $(document).on('af2_calculate_dots', '#af2_slider_value_max', function() { af2_calculate_dots(); });
    $(document).on('af2_calculate_dots', '#af2_slider_start_value', function() { af2_calculate_dots(); });

    $(document).on('af2_calc_label', '#af2_slider_label_wrapper', function() { af2_calc_label(); });


    $(document).on('af2_maps_typein', '#af2_address_start_location', _ => {
        if(!(typeof google === 'object' && typeof google.maps === 'object')) return;

        var autocomplete = new google.maps.places.Autocomplete(
            $('.af2_sidebar_builder_content_text_edit[data-fieldnumber="1"]')[0], {types: ['geocode']}
        );
        autocomplete.bindTo("bounds", window.googleMapObject);
        
        
        setTimeout(() => {
            autocomplete.setFields(["address_component", "geometry"]);
            autocomplete.addListener("place_changed", () => {
                let places = autocomplete.getPlace();
                const loc = places.geometry.location;
                let location_ob = { lat: loc.lat(), lng: loc.lng() };
                af2_builder_object.af2_save_object.startposition.name = $($('.af2_sidebar_builder_content_text_edit[data-fieldnumber="1"]')[0]).val();
                af2_builder_object.af2_save_object.startposition.loc.lat = loc.lat();
                af2_builder_object.af2_save_object.startposition.loc.lng = loc.lng();
                window.googleMapObject.setCenter(location_ob);           
            });
        }, 1000);
    });

    $(document).on('af2_maps_zoom', '#af2_address_zoom', function() {
        if(window.googleMapObject != null) window.googleMapObject.setZoom(parseInt(af2_builder_object.af2_save_object.zoomlevel));
    });

    
    
    
    const set_move_button_field_sidebar_element = af2_builder_object.sidebar_elements.find(element => element.editContentId == 'html');
    const set_move_button_field = set_move_button_field_sidebar_element.fields.find(element => element.details.saveObjectId == 'content_button');
    af2_load_field_html_data(set_move_button_field_sidebar_element, set_move_button_field);

    const af2_slider_enable_manual_field_sidebar_element = af2_builder_object.sidebar_elements.find(element => element.editContentId == 'slider');
    const af2_slider_enable_manual_field = af2_slider_enable_manual_field_sidebar_element.fields.find(element => element.details.saveObjectId == 'manual');
    af2_load_field_html_data(af2_slider_enable_manual_field_sidebar_element, af2_slider_enable_manual_field);

    af2_calculate_dots();
    af2_calc_label();

    $('#af2_create_new_question').on('click', ev => {
        af2_save_builder( _ => {
            window.location.href = af2_fragenbuilder_object.create_new_question_url;
        });
    });
});