<?php


add_action('init', 'af2_v_migration');

function af2_v_migration() {
    $af2_version_num_ = intval(get_option('af2_version_num_'));
    if($af2_version_num_ < 2) {
    
        if (!get_option('af2_license_key')) {
            add_option('af2_license_key', '');
        }
        $license_key = !get_option('license_key') ? '' : get_option('license_key');
        update_option( 'af2_license_key', $license_key );

        if (!get_option('af2_license_stat')) {
            add_option('af2_license_stat', '');
        }
        $license_stat = !get_option('license_stat') ? '' : get_option('license_stat');
        update_option( 'af2_license_stat', $license_stat );

        if (!get_option('af2_license_last_updated')) {
            add_option('af2_license_last_updated', '');
        }
        $license_last_updated = !get_option('license_last_updated') ? '' : get_option('license_last_updated');
        update_option( 'af2_license_last_updated', $license_last_updated );
        

        $frage_posts = get_posts([
            'post_type' => FRAGE_POST_TYPE,
            'post_status' => 'any',
            'numberposts' => -1,
            'order'    => 'ASC'
        ]);
        
        foreach($frage_posts as $post) {
            
            $post_content = get_post_field( 'post_content', $post );
            $post_status = get_post_field( 'post_status', $post );
            
            if(substr($post_content, 0, 1) == '{') {
                wp_insert_post(array('post_content' => $post_content, 'post_type' => FRAGE_BACKUP_POST_TYPE, 'post_status' => $post_status));
    
                $id = get_post_field( 'ID', $post );
    
                $post_array = json_decode($post_content, true); // make post status
                $post_array['tracking_code'] = base64_decode( $post_array['tracking_code'] );
                wp_update_post( array('ID' => $id, 'post_status' => $post_status, 'post_content' => urlencode(serialize($post_array))));
            }
        }

        $kontaktformular_posts = get_posts([
            'post_type' => KONTAKTFORMULAR_POST_TYPE,
            'post_status' => 'any',
            'numberposts' => -1,
            'order'    => 'ASC'
        ]);
        
        foreach($kontaktformular_posts as $post) {
            
            $post_content = get_post_field( 'post_content', $post );
            $post_status = get_post_field( 'post_status', $post );
    
            if(substr($post_content, 0, 1) == '{') {
                wp_insert_post(array('post_content' => $post_content, 'post_type' => KONTAKTFORMULAR_BACKUP_POST_TYPE, 'post_status' => $post_status));
    
                $id = get_post_field( 'ID', $post );
    
                $post_array = json_decode($post_content, true); // make post status

                if(isset($post_array['questions']) && is_array($post_array['questions'])) {
                    for($i = 0; $i < sizeof($post_array['questions']); $i++) {
                        if($post_array['questions'][$i]['typ'] == 'text_type_name') $post_array['questions'][$i]['icon'] = 'fas fa-user';
                        if($post_array['questions'][$i]['typ'] == 'text_type_mail') $post_array['questions'][$i]['icon'] = 'fas fa-envelope';
                        if($post_array['questions'][$i]['typ'] == 'text_type_phone') $post_array['questions'][$i]['icon'] = 'fas fa-phone';
                    }
                }

                wp_update_post( array('ID' => $id, 'post_status' => $post_status, 'post_content' => urlencode(serialize($post_array))));
            }
        }

        $formular_posts = get_posts([
            'post_type' => FORMULAR_POST_TYPE,
            'post_status' => 'any',
            'numberposts' => -1,
            'order'    => 'ASC'
        ]);
        
        foreach($formular_posts as $post) {
            
            $post_content = get_post_field( 'post_content', $post );
            $post_status = get_post_field( 'post_status', $post );
    
            if(substr($post_content, 0, 1) == '{') {
                wp_insert_post(array('post_content' => $post_content, 'post_type' => FORMULAR_BACKUP_POST_TYPE, 'post_status' => $post_status));
    
                $id = get_post_field( 'ID', $post );
    
                $post_array = json_decode($post_content, true); // make post status
                $post_array['migration'] = true;
                wp_update_post( array('ID' => $id, 'post_status' => $post_status, 'post_content' => urlencode(serialize($post_array))));
            }
        }

        $terminevent_posts = get_posts([
            'post_type' => TERMINEVENT_POST_TYPE,
            'post_status' => 'any',
            'numberposts' => -1,
            'order'    => 'ASC'
        ]);
        
        foreach($terminevent_posts as $post) {
            
            $post_content = get_post_field( 'post_content', $post );
            $post_status = get_post_field( 'post_status', $post );
            $post_title = get_post_field( 'post_title', $post );
    
            if(substr($post_content, 0, 1) == '{') {
                wp_insert_post(array('post_content' => $post_content, 'post_type' => TERMINEVENT_BACKUP_POST_TYPE, 'post_status' => $post_status));
    
                $id = get_post_field( 'ID', $post );
    
                $post_array = json_decode($post_content, true); // make post status

                $post_array['title'] = $post_title;

                wp_update_post( array('ID' => $id, 'post_status' => $post_status, 'post_content' => urlencode(serialize($post_array))));
            }
        }

        $request_posts = get_posts([
            'post_type' => REQUEST_POST_TYPE,
            'post_status' => 'any',
            'numberposts' => -1,
            'order'    => 'ASC'
        ]);
        
        foreach($request_posts as $post) {
            
            $post_content = get_post_field( 'post_content', $post );
            $post_status = get_post_field( 'post_status', $post );
            $post_title = get_post_field( 'post_title', $post );
    
            if(substr($post_content, 0, 1) == '{') {
                wp_insert_post(array('post_content' => $post_content, 'post_type' => REQUEST_BACKUP_POST_TYPE, 'post_status' => $post_status));
    
                $id = get_post_field( 'ID', $post );
    
                $post_array = json_decode($post_content, true);

                wp_update_post( array('ID' => $id, 'post_status' => $post_status, 'post_content' => urlencode(serialize($post_array))));
            }
        }

        $request_posts = get_posts([
            'post_type' => TERMIN_POST_TYPE,
            'post_status' => 'any',
            'numberposts' => -1,
            'order'    => 'ASC'
        ]);
        
        foreach($request_posts as $post) {
            
            $post_content = get_post_field( 'post_content', $post );
            $post_status = get_post_field( 'post_status', $post );
    
            if(substr($post_content, 0, 1) == '{') {
                wp_insert_post(array('post_content' => $post_content, 'post_type' => TERMIN_BACKUP_POST_TYPE, 'post_status' => $post_status));
    
                $id = get_post_field( 'ID', $post );
    
                $post_array = json_decode($post_content, true);

                wp_update_post( array('ID' => $id, 'post_status' => $post_status, 'post_content' => urlencode(serialize($post_array))));
            }
        }


    
        update_option('af2_version_num_', '2');
    }
}