# PipeDrive CMS Integration file

This class can be use to simple PipeDrive integration for adding Persons(contacts).

## Usage
 
### How to verify API Key before save verify_api_key()

```php

include AF2_PLUGIN_DIR . '/integrations/PipeDrive_Integration/PipeDrive_Integration_Handler.php';
$api_key = 'xxxxxxxxxxxxxx';
$api_url = 'https://yourdomain.pipedrive.com';

$PPOject = new PipeDrive_integration();
$usersData = $PPOject->verify_api_key($api_key);

if( isset($usersData['data']) && count($usersData['data']) > 0 ){
    // Save the API KEY in DB, and Enable the feature.
    // It will gives all the users of PipeDrive
}else{
    // 'API key is worng
}

```

### How to get list of all Persons(contacts) get_contacts()
to get persons data

```php

include AF2_PLUGIN_DIR . '/integrations/PipeDrive_Integration/PipeDrive_Integration_Handler.php';

$PPOject = new PipeDrive_integration();
$result = $PPOject->get_contacts(); // this will gives Object with response property with list array
$list json_decode( $result->response, true );

```

### Add Person  add_contact()

```php
include AF2_PLUGIN_DIR . '/integrations/PipeDrive_Integration/PipeDrive_Integration_Handler.php';

$data = array( "name" => "James Bond", "email" => array("james@example.com"), "phone" => array("123-456-7890") );

$PPOject = new PipeDrive_integration();
$addContact = $PPOject->add_contact( $data );
// That will return person object in response property

```

### Add Or update Person add_update_contact()
By default Pipedrive will add duplicate entry, but if we want to check and if email id already exist we can update that Person details instead of making duplicate entry.

```php
include AF2_PLUGIN_DIR . '/integrations/PipeDrive_Integration/PipeDrive_Integration_Handler.php';

$data = array( "name" => "James Bond", "email" => array("james@example.com"), "phone" => array("123-456-7890") );

$PPOject = new PipeDrive_integration();
$addContact = $PPOject->add_update_contact( $data );
// That will return person object in response property

```

### Update Person update_contact()

```php
include AF2_PLUGIN_DIR . '/integrations/PipeDrive_Integration/PipeDrive_Integration_Handler.php';

$data = array( "name" => "James Bond", "email" => array("james@example.com"), "phone" => array("123-456-7890") );
$person_id = 7;

$PPOject = new PipeDrive_integration();
$addContact = $PPOject->update_contact( $data, $person_id );
// That will return person object in response property

```

### Search Any Person by Email id search_contact()

```php
include AF2_PLUGIN_DIR . '/integrations/PipeDrive_Integration/PipeDrive_Integration_Handler.php';

$email = "james@example.com";

$PPOject = new PipeDrive_integration();
$addContact = $PPOject->search_contact( $email );
// That will return list of all matched result in response property

```