# MailChimp Integration file

This class can be use to simple mailchimp integration for adding contacts to any list.

## Usage

### How to verify API Key before save

```php

$api_key = $_POST['form_input_api_key'];

include AF2_PLUGIN_DIR . '/integrations/MailChimp_Integration/MailChimp_Integration_Handler.php';

$MailChimp = new MailChimp_Integration();
$verified = $MailChimp->verify_api_key($api_key);
if(( $verified instanceof Exception) ){
    echo 'Error:' . $verified->getMessage();
} else {
    if( 'varified' == $verified){
        update_option('af2_mailchimp_api_key', $api_key);
        echo 'MailChimp Credentials successfully verified and saved';
    }else{
        echo 'Error:' .$verified;
    }
}

```

### How to get audience lists
to get list (audience) ID which is required to add contact to mailchimp.

```php

include AF2_PLUGIN_DIR . '/integrations/MailChimp_Integration/MailChimp_Integration_Handler.php';

// Optionally we can check if Mailchimp integration is enabled
// if( !get_option('af2_mailchimp_enable') ) return;

$MailChimp = new MailChimp_Integration();
$list = $MailChimp->get_all_lists(); // this will gives Array of all list we can then use list ID etc.

```

### Add contact to given list
we need 2 things here, contact array (or JSON string) and list id in which we want to add the contact
return "added" on success

```php

$data = '{
        "email_address": "john@example.com",
        "status": "subscribed",
        "merge_fields": {
          "FNAME": "john",
          "LNAME": "smith",
          "PHONE": "phone",
          "ADDRESS": {
            "addr1": "123 Freddie Ave",
            "city": "Atlanta",
            "state": "GA",
            "zip": "12345",
          }
        }
    }';
$list_id = '902678a77a';

include AF2_PLUGIN_DIR . '/integrations/MailChimp_Integration/MailChimp_Integration_Handler.php';

$MailChimp = new MailChimp_Integration();
$addContact = $MailChimp->add_update_contact_to_list( $data, $list_id);
// That will return "added" on success.
// or error string on fail.
// or Exception 


```

In the above example we used "add_update_contact_to_list" method which will add any new contact and update any existing contact based on their email_address.
We can also use other method "add_contact_to_list" which can only add any user.

## This Class also have some demo functions
Following functions/methods are created to test api calls

```php

test_set_credential($api_key); // set api key for testing without seving it to DB, to call APIs.

test_setting_form(); // To create a simple form

test_setting_form_handler(); // To testing form submit and save data

```