# GetResponse Integration file

This class can be use to simple getResponse integration for adding contacts to any list.

## Usage

### How to verify API Key before save

```php

include AF2_PLUGIN_DIR . '/integrations/GetResponse_Integration/GetResponse_Integration_Handler.php';
$api_key = 'xxxxxxxxxxxxxx';
$GetResponse = new GetResponse_integration();
$verified = $GetResponse->verify_api_key($api_key);

if( count($verified) > 0 ){
    // Save the API KEY in DB, and Enable the feature.
    echo 'GetResponse Credentials successfully verified and saved';
}else{
    echo 'API key is worng';
}

```

### How to get campaigns lists
to get campaigns ID which is required to add contact.

```php

include AF2_PLUGIN_DIR . '/integrations/GetResponse_Integration/GetResponse_Integration_Handler.php';

// Optionally we can check if GetResponse integration is enabled from DB

$GetResponse = new GetResponse_integration();
$list = $GetResponse->get_campaigns(); // this will gives Array of all list we can then use list ID [campaignId] etc.

```

### Add contact to given compaign list
we need 2 things here, contact array (or JSON string) and list/compaign id ( [campaignId] ) in which we want to add the contact
return "added" on success

```php

$campaign_id = 'aAAb';
$contact = array(
    'email'     => 'john@example.com',
    'name' => 'john smith',
    'campaign'  => array( 'campaignId' => $campaign_id )
);
if (isset($_SERVER['REMOTE_ADDR'])) {
    $contact['ipAddress'] = $_SERVER['REMOTE_ADDR'];
}

include AF2_PLUGIN_DIR . '/integrations/GetResponse_Integration/GetResponse_Integration_Handler.php';

$GetResponse = new GetResponse_integration();
$addContact = $GetResponse->add_contact( $contact);
// That will return "added" on success.
// or error string on fail.
// or Exception 
// like if contact is already exist in that list it will gives string : "Contact already added"

```
