<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2Terminevents extends Af2MenuTable {

    protected function get_heading() { return 'Appointment events'; }
    protected function get_menu_action_button_add_post_() { return array('page' => TERMINEVENT_SLUG, 'post_type' => TERMINEVENT_POST_TYPE, 'builder' => TERMINEVENTBUILDER_SLUG); }
    protected function get_menu_action_button_copy_posts_() { return true; }
    protected function get_menu_action_button_delete_posts_() { return true; }
    protected function get_post_type_constant() { return TERMINEVENT_POST_TYPE; }
    protected function get_table_builder_load_array_() { return array( 'page' => TERMINEVENTBUILDER_SLUG, 'id_label' => 'ID'); }
    protected function get_table_columns() {
        return array(
            array( 'lable' => 'ID', 'translate' => false, 'highlight' => false,                 'width' => '110px', 'flex' => '',  'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => true),
            array( 'lable' => 'Appointment event title', 'translate' => false, 'highlight' => true,    'width' => '',      'flex' => '1', 'max-width' => '', 'min-width' => '', 'button' => false, 'url' => true, 'uid' => false),
            array( 'lable' => 'Appointment event type', 'translate' => true, 'highlight' => false,       'width' => '180px', 'flex' => '1',  'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => false),
            array( 'lable' => 'Author', 'translate' => false, 'highlight' => false,              'width' => '200px', 'flex' => '',  'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => false),
        ); 
    }
    protected function edit_posts_for_table($posts) {
        $new_posts = array();

        require_once AF2_MISC_FUNCTIONS_PATH;
        foreach($posts as $post) {

            $post_content = af2_get_post_content($post);
            $title = isset($post_content['title']) && !empty($post_content['title']) ? $post_content['title'] : __('Appointment event title', 'af2_multilanguage');

            $typename = isset($post_content['typ']) ? $post_content['typ'] : 'Nicht vorhanden';
            if($typename == 'meeting_personal') $typename = 'Personal appointment';
            if($typename == 'meeting_call') $typename = 'Call';
            if($typename == 'meeting_video') $typename = 'Video conference';

            // remove warnigns
            $title = isset($title) && !empty($title) ? $title : __('No title specified!', 'af2_multilanguage');
            $new_post = array();
            $new_post['ID'] = get_post_field('ID', $post );
            $new_post['Appointment event title'] = $title;
            $new_post['Appointment event type'] = $typename;
            $new_post['Author'] = get_the_author_meta( 'display_name', get_post_field('post_author', $post ) );

            $new_post['error'] = isset($post_content['error']) ? $post_content['error'] : false;
            
            array_push($new_posts, $new_post);
        }

        return $new_posts;
    }
}