<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2Termine extends Af2MenuTable {

    protected function get_heading() { return 'Appointments'; }
    protected function get_menu_action_button_delete_posts_() { return true; }
    protected function get_post_type_constant() { return TERMIN_POST_TYPE; }
    protected function get_table_builder_load_array_() { return array( 'page' => LEADS_DETAILS_SLUG, 'id_label' => 'lead_id'); }
    protected function get_menu_hook_inline_checkbox_() { 
        return array( 
            'id' => 'af2_show_outdated',
            'active' => false,
            'label'  => 'Show past appointments'
        );
    }
    protected function get_menu_functions_select_() { 

        $posts = $this->Admin->af2_get_posts(TERMINEVENT_POST_TYPE);

        $all_terminevents = array();

        require_once AF2_MISC_FUNCTIONS_PATH;
        foreach($posts as $post) {
            if(get_post_field( 'post_status', $post ) == 'draft') continue;

            $id = get_post_field( 'ID', $post );
            $post_content = af2_get_post_content($post);

            // remove warnigns
            $title = isset($post_content['title']) && !empty($post_content['title']) ? $post_content['title'] : __('Appointment event title', 'af2_multilanguage');

            array_push($all_terminevents, array('value' => $id, 'label' => $title));
        }

        return array( 
            'title' => __('Select appointment event:', 'af2_multilanguage'),
            'id' => 'terminevent_id_chooser',
            'getattribute' => 'terminbuchungsid',
            'link' => admin_url('/admin.php?page='.TERMIN_SLUG),
            'selected' => isset($_GET['terminbuchungsid']) ? $_GET['terminbuchungsid'] : 'all',
            'all_label' => __('All appointment events', 'af2_multilanguage'),
            'options' => $all_terminevents,
        ); 
    }
    protected function get_table_columns() {
        return array(
            array( 'lable' => 'ID', 'translate' => false, 'highlight' => false,                         'width' => '110px', 'flex' => '',  'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => true),
            array( 'lable' => 'Appointment title', 'translate' => false, 'highlight' => false,                      'width' => '',      'flex' => '1', 'max-width' => '', 'min-width' => '', 'button' => false, 'url' => true, 'uid' => false),
            array( 'lable' => 'Date', 'translate' => false, 'highlight' => false,                      'width' => '', 'flex' => '0.4',  'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => false),
            array( 'lable' => 'Time', 'translate' => false, 'highlight' => false,                       'width' => '', 'flex' => '0.4',  'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => false),
            array( 'lable' => 'Duration', 'translate' => false, 'highlight' => false,                      'width' => '', 'flex' => '0.4',  'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => false),
            array( 'lable' => 'Details', 'translate' => true, 'highlight' => false,                     'width' => '160px', 'flex' => '',  'max-width' => '', 'min-width' => '', 'url' => true, 'button' => true, 'buttonclass' => 'primary', 'uid' => false),
            array( 'lable' => 'lead_id', 'hidden' => true, 'translate' => false, 'highlight' => false,  'width' => '160px', 'flex' => '',  'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => false),
        ); 
    }
    protected function edit_posts_for_table($posts) {
        $terminbuchungsid = isset($_GET['terminbuchungsid']) ? $_GET['terminbuchungsid'] : 'all';
        $new_posts = array();

        require_once AF2_MISC_FUNCTIONS_PATH;
        foreach($posts as $post) {

            $post_content = af2_get_post_content($post);

            // remove warnigns


            $new_post = array();
            $new_post['ID'] = get_post_field('ID', $post );
            $new_post['Appointment title'] = isset($post_content['titel']) ? $post_content['titel'] : $post_content['title'];
            $new_post['Date'] = $post_content['datum'];
            $new_post['Time'] =  $post_content['zeit'];
            $new_post['Duration'] =  $post_content['dauer'];
            $new_post['Details'] = 'Details';
            $new_post['lead_id'] = $post_content['lead_id'];

            $new_post['error'] = isset($post_content['error']) ? $post_content['error'] : false;

            
            if($terminbuchungsid == 'all' || (isset($post_content['form_id']) && $terminbuchungsid == $post_content['form_id'])) array_push($new_posts, $new_post);
        }

        return $new_posts;
    }

    protected function load_resources() {
        wp_enqueue_script('af2_termin');

        parent::load_resources();
    }
}