<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2Kontaktformulare extends Af2MenuTable {

    protected function get_heading() { return 'Contact forms'; }
    protected function get_menu_functions_search_() { return array('Contact form title (backend)', 'Contact form title (frontend)'); }
    protected function get_menu_action_button_add_post_() { return array('page' => KONTAKTFORMULAR_SLUG, 'post_type' => KONTAKTFORMULAR_POST_TYPE, 'builder' => KONTAKTFORMULARBUILDER_SLUG); }
    protected function get_menu_action_button_copy_posts_() { return true; }
    protected function get_menu_action_button_delete_posts_() { return true; }
    protected function get_post_type_constant() { return KONTAKTFORMULAR_POST_TYPE; }
    protected function get_table_builder_load_array_() { return array( 'page' => KONTAKTFORMULARBUILDER_SLUG, 'id_label' => 'ID'); }
    protected function get_table_columns() {
        require_once AF2_CATEGORY_HANDLER_PATH;
        return array(
            array( 'lable' => 'ID', 'translate' => false, 'highlight' => false,                                 'width' => '110px',     'flex' => '',   'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => true),
            array( 'lable' => 'Contact form title (backend)', 'translate' => false, 'highlight' => true,      'width' => '',          'flex' => '1',  'max-width' => '', 'min-width' => '', 'button' => false, 'url' => true, 'uid' => false),
            array( 'lable' => 'Contact form title (frontend)', 'translate' => false, 'highlight' => false,    'width' => '',          'flex' => '1',  'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => false),
            array( 'lable' => 'Author', 'translate' => false, 'highlight' => false,                              'width' => '200px',     'flex' => '',   'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => false),
            array( 'lable' => 'Category', 'translate' => true, 'highlight' => false,   'width' => '',      'flex' => '0.5',  'min-width' => '', 'max-width'=> '', 'button' => false, 'uid' => false, 'select' => 
                array('selection_values' => get_all_categories(), 'select_class' => 'af2_category_selection', 'empty_value' => 'Not assigned')
            ),
        ); 
    }
    protected function get_custom_template_() { return AF2_CUSTOM_TEMPLATE_CATEGORY; }

    protected function get_menu_functions_button_() { 
        return array(
            'icon' => 'fas fa-cog', 
            'label' => __('Edit categories', 'af2_multilanguage'),
            'triggerId' => 'af2_open_categories_model',
            'modelTarget' => 'modal-categories',
            'dataAttributes' => array(
                'target' => 'modal-categories',
            )
        ); 
    }

    protected function get_menu_functions_select_() {
        require_once AF2_CATEGORY_HANDLER_PATH;
        $all_cats = get_all_categories();

        return array( 
            'title' => __('Category:', 'af2_multilanguage'), 
            'id' => 'choose_category',
            'getattribute' => 'category_id',
            'link' => admin_url('/admin.php?page='.KONTAKTFORMULAR_SLUG),
            'selected' => isset($_GET['category_id']) ? intval($_GET['category_id']) : 'all',
            'all_label' => __('No category selected', 'af2_multilanguage'),
            'options' => $all_cats,
        );
    }

    protected function edit_posts_for_table($posts) {
        $new_posts = array();

        require_once AF2_MISC_FUNCTIONS_PATH;
        foreach($posts as $post) {

            require_once AF2_CATEGORY_HANDLER_PATH;
            $id = get_post_field('ID', $post );
            $category_id = get_category_id_of_element($id);

            $post_content = af2_get_post_content($post);

            // remove warnings
            $name = isset($post_content['name']) && !empty($post_content['name']) ? $post_content['name'] : __('Contact form title (backend)', 'af2_multilanguage');
            $cftitle = isset($post_content['cftitle']) && !empty($post_content['cftitle']) ? $post_content['cftitle'] : __('Contact form title (frontend)', 'af2_multilanguage');

            $new_post = array();
            $new_post['ID'] = $id;
            $new_post['Contact form title (backend)'] = $name;
            $new_post['Contact form title (frontend)'] =  $cftitle;
            $new_post['Author'] = get_the_author_meta( 'display_name', get_post_field('post_author', $post ) );
            $new_post['Category'] = $category_id;

            $new_post['error'] = isset($post_content['error']) ? $post_content['error'] : false;
            
            if(isset($_GET['category_id'])) {
                if(intval($_GET['category_id']) === $category_id || $_GET['category_id'] === 'all') array_push($new_posts, $new_post);
            }
            else array_push($new_posts, $new_post);
        }

        return $new_posts;
    }



    protected function load_resources() {
        wp_localize_script( 'af2_category_script', 'af2_category_object', array(
            'reload_url' => admin_url('/admin.php?page='.KONTAKTFORMULAR_SLUG.'&show_modal=show_category_modal'),
            'reload_url_nomodal' => admin_url('/admin.php?page='.KONTAKTFORMULAR_SLUG),
        ));
        wp_enqueue_script('af2_category_script');
        wp_enqueue_style('af2_category');

        parent::load_resources();
    }
}