<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2Formulare extends Af2MenuTable{

    protected function get_heading() { return 'Forms'; }
    protected function get_menu_functions_search_() { return 'Form title (backend)'; }
    protected function get_menu_action_button_add_post_() { return array('page' => FORMULAR_SLUG, 'post_type' => FORMULAR_POST_TYPE, 'builder' => FORMULARBUILDER_SLUG); }
    protected function get_menu_action_button_copy_posts_() { return true; }
    protected function get_menu_action_button_delete_posts_() { return true; }
    protected function get_post_type_constant() { return FORMULAR_POST_TYPE; }
    protected function get_table_builder_load_array_() { return array( 'page' => FORMULARBUILDER_SLUG, 'id_label' => 'ID'); }
    protected function get_table_builder_load_array_ids_() { return array( 
        array( 'page' => LEADS_SLUG, 'id_param' => 'form_id', 'id_label' => 'ID' ) 
    ); }
    protected function get_table_columns() {
        return array(
            array( 'lable' => 'ID', 'translate' => false, 'highlight' => false,                                     'width' => '110px', 'flex' => '',  'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => true),
            array( 'lable' => 'Form title (backend)', 'translate' => false, 'highlight' => true, 'url' => true,  'width' => '',      'flex' => '0.4', 'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => false),
            array( 'lable' => 'WordPress shortcode', 'translate' => true, 'highlight' => false,            'width' => '280px', 'flex' => '',  'max-width' => '', 'min-width' => '', 'button' => false, 'uid' => false),
            array( 'lable' => 'Popup shortcode', 'translate' => true, 'highlight' => false,                         'width' => '190px', 'flex' => '0.4',  'max-width' => '', 'min-width' => '', 'button' => true, 'buttonclass' => 'secondary_outline open_popup_embed_code', 'buttonid' => true, 'uid' => false),
            array( 'lable' => 'External embed code', 'translate' => true, 'highlight' => false,                'width' => '190px', 'flex' => '0.4',  'max-width' => '', 'min-width' => '', 'button' => true, 'buttonclass' => 'secondary_outline open_external_embed_code', 'buttonid' => true, 'uid' => false),
            array( 'lable' => 'Leads', 'translate' => true, 'highlight' => true,                                    'width' => '190px', 'flex' => '0.4',  'max-width' => '', 'min-width' => '', 'button' => true, 'buttonclass' => 'primary', 'url' => true, 'urlnum' => 0, 'uid' => false)
        );
    }
    protected function edit_posts_for_table($posts) {
        $new_posts = array();

        require_once AF2_MISC_FUNCTIONS_PATH;
        
        foreach($posts as $post) {

            $post_content = af2_get_post_content($post);

            // remove warnigns
            $title = isset($post_content['name']) && !empty($post_content['name']) ? $post_content['name'] : __('Form title', 'af2_multilanguage');

            $new_post = array();
            $new_post['ID'] = get_post_field('ID', $post );
            $new_post['Form title (backend)'] = $title;
            $new_post['WordPress shortcode'] = '[funnelforms id="'.get_post_field('ID', $post ).'"]';
            $new_post['Popup shortcode'] = 'Generate';
            $new_post['External embed code'] = 'Generate';
            $new_post['Leads'] = 'Show leads';

            $new_post['error'] = isset($post_content['error']) ? $post_content['error'] : false;
            
            array_push($new_posts, $new_post);
        }

        return $new_posts;
    }

    protected function get_custom_template_() {
        return AF2_CUSTOM_TEMPLATE_FORMULARE;
    }

    protected function load_resources() {
        wp_localize_script( 'af2_formulare', 'af2_formulare_object', array(
            "strings" => array(
                "plugin_dir_url" => plugin_dir_url( AF2_PLUGIN ),
                "site_url" => site_url('/'),
            ),
        ));
        wp_enqueue_script('af2_formulare');

        parent::load_resources();
    }
}