<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2FormularbuilderSettings extends Af2MenuBuilder {

    protected function get_builder_heading() { return array('label' => 'Form editor', 'icon' => 'fas fa-edit'); }
    protected function get_builder_template() { return AF2_BUILDER_TEMPLATE_FORMULAR_SETTINGS; }
    protected function get_builder_sidebar_edit_() { return array('label' => 'Settings'); }
    protected function get_menu_builder_control_buttons_() { return array(array('id' => 'af2_goto_formularbuilder', 'icon' => 'fas fa-cog', 'label' => 'Back to Editor')); }

    protected function get_close_editor_url() { return admin_url('/admin.php?page='.FORMULAR_SLUG ); }

    protected function get_builder_script() { return 'af2_formularbuilder_settings'; }
    protected function get_builder_style() { return 'af2_formularbuilder_settings_style'; }
    protected function get_builder_script_object_name() { return 'af2_formularbuilder_settings_object';  }
    protected function get_builder_script_localize_array() { 
        return array(
            'redirect_formularbuilder_url' => admin_url('/admin.php?page='.FORMULARBUILDER_SLUG.'&id='.$_GET['id'] ),
            'redirect_formularbuilder_preview_url' => admin_url('/admin.php?page='.FORMULARBUILDER_PREVIEW_SLUG.'&id='.$_GET['id'] ),
            'standard_success_image' => plugins_url('/res/images/success_standard.png', AF2_PLUGIN),
            'strings' => array(
                'success_text' => __('Thank you! The form was sent successfully!', 'af2_multilanguage'),
            )
        );
    }
    
    protected function get_builder_sidebar_edit_elements_() {
        require_once AF2_MENU_FORMULARBUILDER_SETTINGS_ELEMENTS_PATH;
        return get_formularbuilder_settings_elements();
    }

    protected function load_resources() {
        require_once AF2_RESOURCE_HANDLER_PATH;
        load_media_iconpicker();
        load_colorpicker();

        parent::load_resources();
    }


    public static function save_function($content) {
        $own_content = $content;
        $echo_content = array();

        if(!isset($own_content['name']) || trim($own_content['name']) == '') {
            array_push($echo_content, array('label' => __('No title specified!', 'af2_multilanguage'), 'type' => 'af2_error'));
        }

        $keys = array('fe_title', 'global_next_text', 'global_prev_text');
        foreach($own_content['styling'] as $key => $value) {
            if(in_array($key, $keys)) continue;
            if(!isset($value) || trim($value) == '') {
                array_push($echo_content, array('label' => __('Design values can not be saved empty!', 'af2_multilanguage'), 'type' => 'af2_error'));
            }
        }

        array_push($echo_content, array('label' => __('Saved successfully!', 'af2_multilanguage'), 'type' => 'af2_success'));


        $own_content['error'] = false;

        foreach( $echo_content as $content ) {
            if($content['type'] == 'af2_error') {
                $own_content['error'] = true;
                break;
            }
        }

        echo json_encode($echo_content);
        return $own_content;
    }
}