<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2Formularbuilder extends Af2MenuBuilder {

    private $dnp_integration;
    private $ac_integration;
    private $pipedrive_integration;
    private $getresponse_integration;
    private $hubspot_integration;
    private $fincrm_integration;
    private $klicktipp_integration;

    public function __construct($Admin) {
        require_once AF2_INTEGRATION_HANDLER_DEALSNPROJECTS;
        $this->dnp_integration = new DealsNProjects_Integration();
    
        require_once AF2_INTEGRATION_HANDLER_ACTIVECAMPAIGN;
        $this->ac_integration = new ActiveCampaign_Integration();

        require_once AF2_INTEGRATION_HANDLER_PIPEDRIVE;
        $this->pipedrive_integration = new PipeDrive_Integration();

        require_once AF2_INTEGRATION_HANDLER_GETRESPONSE;
        $this->getresponse_integration = new GetResponse_Integration();

        require_once AF2_INTEGRATION_HANDLER_HUBSPOT;
        $this->hubspot_integration = new HubSpot_Integration();

        require_once AF2_INTEGRATION_HANDLER_FINCRM;
        $this->fincrm_integration = new FinCRM_Integration();

        require_once AF2_INTEGRATION_HANDLER_KLICKTIPP;
        $this->klicktipp_integration = new Klicktipp_Integration();

        parent::__construct($Admin);
    }

    protected function get_builder_sidebar_select_filter_() {
        require_once AF2_CATEGORY_HANDLER_PATH;
        $all_cats = get_all_categories();
        return array(
            'select_class' => 'af2_category_select',
            'empty_value' => __('All Categories', 'af2_multilanguage'),
            'selection_values' => $all_cats
        );
    }

    protected function get_builder_heading() { return array('label' => 'Form editor', 'icon' => 'fas fa-edit'); }
    protected function get_builder_sidebar_data_() { return array('label' => 'Elements', 'icon' => 'fas fa-atom'); }
    protected function get_builder_template() { return AF2_BUILDER_TEMPLATE_FORMULAR; }


    protected function get_close_editor_url() { return admin_url('/admin.php?page='.FORMULAR_SLUG ); }

    protected function get_menu_builder_control_buttons_() { return array(
        array('id' => 'af2_goto_formularbuilder_settings', 'icon' => 'fas fa-cog', 'label' => 'Design & Settings'),
        array('id' => 'af2_sort_form_questions', 'icon' => 'fas fa-sync', 'label' => 'Sort')
        ); }
    protected function get_builder_sidebar_content_element_class_() { return 'af2_array_add_draggable'; }
    protected function get_builder_pre_heading_buttons_() { return array(array('id' => 'af2_zoom_out', 'icon' => 'fas fa-minus'), array('id' => 'af2_zoom_in', 'icon' => 'fas fa-plus')); }

    protected function af2_own_save_button_id_() { return 'af2_save_post_'; } 

    protected function get_builder_sidebar_content_elements_() {
        require_once AF2_CATEGORY_HANDLER_PATH;
        $elements_array = array();

        $frage_posts = $this->Admin->af2_get_posts(FRAGE_POST_TYPE);

        foreach($frage_posts as $post) {

            require_once AF2_MISC_FUNCTIONS_PATH;
            $post_content = af2_get_post_content($post);

            $id = get_post_field('ID', $post );
            $category_id = get_category_id_of_element($id);
            $title = isset($post_content['name']) ? $post_content['name'] : '';
            $typ = isset($post_content['typ']) ? $this->Admin->af2_convert_question_type($post_content['typ']) : null;

            if($typ != null) {
                $post_array = array('label' => $title, 'image' => $this->Admin->af2_get_question_type_resource_by_label($typ), 'elementid' => $id, 'select_value' => $category_id);
                if(!(isset($post_content['error']) && $post_content['error'] == 'true')) array_push($elements_array, $post_array);
            }
        }

        $kontaktformular_posts = $this->Admin->af2_get_posts(KONTAKTFORMULAR_POST_TYPE);

        foreach($kontaktformular_posts as $post) {

            require_once AF2_MISC_FUNCTIONS_PATH;
            $post_content = af2_get_post_content($post);

            $id = get_post_field('ID', $post );
            $category_id = get_category_id_of_element($id);
            $title = isset($post_content['name']) ? $post_content['name'] : '';
            $post_array = array('label' => $title, 'icon' => 'fas fa-envelope', 'elementid' => $id, 'select_value' => $category_id);
            if(!(isset($post_content['error']) && $post_content['error'] == 'true')) array_push($elements_array, $post_array);
        }

        array_push($elements_array, array('label' => __('URL redirect', 'af2_multilanguage'), 'icon' => 'fas fa-external-link-alt', 'elementid' => 'redirect:'));
        array_push($elements_array, array('label' => __('Webhook', 'af2_multilanguage'), 'icon' => 'fas fa-link', 'elementid' => 'webhook:'));

        if($this->dnp_integration->is_active()) array_push($elements_array, array('label' => __('Deals and Projects', 'af2_multilanguage'), 'icon' => 'fas fa-rocket', 'elementid' => 'dealsnprojects:'));
        if($this->ac_integration->is_active()) array_push($elements_array, array('label' => __('ActiveCampaign', 'af2_multilanguage'), 'icon' => 'fas fa-rocket', 'elementid' => 'activecampaign:'));
        if($this->pipedrive_integration->is_active()) array_push($elements_array, array('label' => __('Pipedrive', 'af2_multilanguage'), 'icon' => 'fas fa-rocket', 'elementid' => 'pipedrive:'));
        if($this->getresponse_integration->is_active()) array_push($elements_array, array('label' => __('GetResponse', 'af2_multilanguage'), 'icon' => 'fas fa-rocket', 'elementid' => 'getresponse:'));
        if($this->hubspot_integration->is_active()) array_push($elements_array, array('label' => __('HubSpot', 'af2_multilanguage'), 'icon' => 'fas fa-rocket', 'elementid' => 'hubspot:'));
        if($this->fincrm_integration->is_active()) array_push($elements_array, array('label' => __('FinCRM', 'af2_multilanguage'), 'icon' => 'fas fa-rocket', 'elementid' => 'fincrm:'));
        if($this->klicktipp_integration->is_active()) array_push($elements_array, array('label' => __('KlickTipp', 'af2_multilanguage'), 'icon' => 'fas fa-rocket', 'elementid' => 'klicktipp:'));

        return $elements_array;
    }

    protected function get_builder_script() { return 'af2_formularbuilder'; }
    protected function get_builder_style() { return 'af2_formularbuilder_style'; }
    protected function get_builder_script_object_name() { return 'af2_formularbuilder_object';  }
    protected function get_builder_script_localize_array() { 
        $dnp_data = $this->dnp_integration->is_active() ? $this->dnp_integration->get_api_draw_fields() : null;

        $ac_active = $this->ac_integration->is_active();
        $ac_data = $ac_active ? $this->ac_integration->get_api_draw_fields() : null;
        $ac_api_fields = $ac_active ? $this->ac_integration->fetch_fields_from_api() : null;

        $pd_active = $this->pipedrive_integration->is_active();
        $pd_data = $pd_active ? $this->pipedrive_integration->get_api_draw_fields() : null;
        //$pd_api_fields = $pd_active ? $this->pipedrive_integration->fetch_fields_from_api() : null;

        $gr_active = $this->getresponse_integration->is_active();
        $gr_data = $gr_active ? $this->getresponse_integration->get_api_draw_fields() : null;
        $gr_api_fields = $pd_active ? $this->getresponse_integration->fetch_fields_from_api() : null;

        $hs_active = $this->hubspot_integration->is_active();
        $hs_data = $hs_active ? $this->hubspot_integration->get_api_draw_fields() : null;
        $hs_api_fields = $hs_active ? $this->hubspot_integration->fetch_fields_from_api() : null;

        $fincrm_active = $this->fincrm_integration->is_active();
        $fincrm_data = $fincrm_active ? $this->fincrm_integration->get_api_draw_fields() : null;

        $klicktipp_active = $this->klicktipp_integration->is_active();
        $klicktipp_data = $klicktipp_active ? $this->klicktipp_integration->get_api_draw_fields() : null;
        $klicktipp_api_fields = $klicktipp_active ? $this->klicktipp_integration->fetch_fields_from_api() : null;
        
        return array(
            'own_id' => $_GET['id'],
            'fragen_contents' => $this->get_fragen_contents_for_element_sidebar(),
            'kontaktformular_contents' => $this->get_kontaktformular_contents_for_element_sidebar(),
            'redirect_formularbuilder_settings_url' => admin_url('/admin.php?page='.FORMULARBUILDER_SETTINGS_SLUG.'&id='.$_GET['id'] ),
            'standard_success_image' => plugins_url('/res/images/success_standard.png', AF2_PLUGIN),
            'dealsnprojects:' => $dnp_data,
            'activecampaign:' => $ac_data,
            'pipedrive:' => $pd_data,
            'getresponse:' => $gr_data,
            'fincrm:' => $fincrm_data,
            'hubspot:' => $hs_data,
            'klicktipp:' => $klicktipp_data,
            'api_fields' => array(
                'activecampaign:' => $ac_api_fields,
                'getresponse:' => $gr_api_fields,
                'hubspot:' => $hs_api_fields,
                'klicktipp:' => $klicktipp_api_fields,
            ),
            'strings' => array(
                'addconnection' => __('Add connection', 'af2_multilanguage'),
                'addcondition' => __('Add condition', 'af2_multilanguage'),
                'redirect' => __('URL redirect', 'af2_multilanguage'),
                'redirect_placeholder' => __('Enter URL...', 'af2_multilanguage'),
                'webhook_placeholder' => __('Enter URL...', 'af2_multilanguage'),
                'redirect_checkbox' => __('Open in new window', 'af2_multilanguage'),
                'no_element_error' => __('Element deleted', 'af2_multilanguage'),
                'interface' => __('Interface', 'af2_multilanguage'),
                'editinterface' => __('Edit', 'af2_multilanguage'),
                'dealsnprojects:' => __('Deals and Projects', 'af2_multilanguage'),
                'activecampaign:' => __('ActiveCampaign', 'af2_multilanguage'),
                'fincrm:' => __('FinCRM', 'af2_multilanguage'),
                'hubspot:' => __('HubSpot', 'af2_multilanguage'),
                'pipedrive:' => __('Pipedrive', 'af2_multilanguage'),
                'getresponse:' => __('GetResponse', 'af2_multilanguage'),
                'klicktipp:' => __('KlickTipp', 'af2_multilanguage'),
                'question' => __('Question', 'af2_multilanguage'),
                'contact_form' => __('Contact form', 'af2_multilanguage'),
                'redirect' => __('Redirect', 'af2_multilanguage'),
                'webhook' => __('Webhook', 'af2_multilanguage'),
                'error' => __('Error', 'af2_multilanguage'),
                'choose' => __('Choose...', 'af2_multilanguage'),
                'success_text' => __('Thank you! The form was sent successfully!', 'af2_multilanguage'),
            ),
        );
    }

    protected function load_resources() {
        wp_enqueue_script('af2_interact_js');
        wp_enqueue_script('zoom');
        wp_enqueue_script('af2_svg_handler');
        wp_enqueue_script('af2_dragscroll');
        wp_enqueue_script('af2_drag_drop');
        
        parent::load_resources();
    }

    protected function get_fragen_contents_for_element_sidebar() {
        $elements_array = array();

        $frage_posts = $this->Admin->af2_get_posts(FRAGE_POST_TYPE);

        foreach($frage_posts as $post) {

            require_once AF2_MISC_FUNCTIONS_PATH;
            $post_content = af2_get_post_content($post);
            $id = get_post_field('ID', $post );

            $post_array = array('elementid' => $id, 'content' => $post_content);

            if(!(isset($post_content['error']) && $post_content['error'] == 'true')) array_push($elements_array, $post_array);
        }

        return $elements_array;
    }

    protected function get_kontaktformular_contents_for_element_sidebar() {
        $elements_array = array();

        $kontaktformular_posts = $this->Admin->af2_get_posts(KONTAKTFORMULAR_POST_TYPE);

        foreach($kontaktformular_posts as $post) {

            require_once AF2_MISC_FUNCTIONS_PATH;
            $post_content = af2_get_post_content($post);
            $id = get_post_field('ID', $post );

            $post_array = array('elementid' => $id, 'content' => $post_content);

            if(!(isset($post_content['error']) && $post_content['error'] == 'true')) array_push($elements_array, $post_array);
        }

        return $elements_array;
    }


    public static function save_function($content) {
        $own_content = $content;
        $echo_content = array();

        if(!isset($own_content['name']) || trim($own_content['name']) == '') {
            array_push($echo_content, array('label' => __('No title specified!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_formularbuilder_settings'));
        }

        $keys = array('fe_title', 'global_next_text', 'global_prev_text');
        foreach($own_content['styling'] as $key => $value) {
            if(in_array($key, $keys)) continue;
            if(!isset($value) || trim($value) == '') {
                array_push($echo_content, array('label' => __('Design values can not be saved empty!', 'af2_multilanguage'), 'type' => 'af2_error', 'error_object' => '#af2_goto_formularbuilder_settings'));
            }
        }


        array_push($echo_content, array('label' => __('Saved successfully!', 'af2_multilanguage'), 'type' => 'af2_success'));


        $own_content['error'] = false;

        foreach( $echo_content as $content ) {
            if($content['type'] == 'af2_error') {
                $own_content['error'] = true;
                break;
            }
        }

        echo json_encode($echo_content);
        return $own_content;
    }
}