<?php

require_once AF2_MENU_PARENTS_CLASS;

class Af2Dashboard extends Af2MenuCustom {

    public function __construct($Admin) {
        parent::__construct($Admin);
        
        // Reset if new month
        $reset_dashboard_date_array = $this->Admin->convert_datestring_to_array(get_option('af2_reset_dashboard_date'));
        $actual_date_array = $this->Admin->convert_datestring_to_array(date('Y-m-d H:i:s', time()));
        
        if($reset_dashboard_date_array['month'] != $actual_date_array['month'] || $reset_dashboard_date_array['year'] != $actual_date_array['year']) {
            $this->reset_statistics($reset_dashboard_date_array['month'], $reset_dashboard_date_array['year']);
        }
    }
    
    protected function get_heading() { return 'Dashboard'; }
    protected function get_menu_custom_template() { return AF2_CUSTOM_MENU_DASHBOARD; }
    protected function get_menu_functions_button_() { return array('icon' => 'fas fa-redo', 'label' => __('Reset statistics', 'af2_multilanguage'),
        'triggerId' => 'af2_reset_dashboard', 'link' => admin_url('/admin.php?page='.MAIN_MENU_SLUG.'&action=reset_dashboard' ) ); }

    protected function get_af2_custom_contents_() {
        $impression_count = intval(get_option('af2_impressions'));

        // Get reset time for filtering
        $reset_dashboard_date_array = $this->Admin->convert_datestring_to_array(get_option('af2_reset_dashboard_date'));

        $leads_current_month = $impression_count > 0 ?
        $this->Admin->af2_get_posts( REQUEST_POST_TYPE, array( 
                'year' => intval($reset_dashboard_date_array['year']),
                'month' => intval($reset_dashboard_date_array['month']),
                'day' => intval($reset_dashboard_date_array['day'])
            ) 
        ) : array();

        $lead_count = sizeof($leads_current_month);
        $conversionrate = $impression_count != 0 && $lead_count != 0 ? round((($lead_count / $impression_count) * 100), 2).'%' : '-';
        $impressionfactor = $impression_count != 0 && $lead_count != 0 ? round(($impression_count / $lead_count), 2) : '-';

        return array(
            'impressions' => get_option('af2_impressions'),
            'leads' => $lead_count,
            'conversionrate' => $conversionrate,
            'impressionfactor' => $impressionfactor,
            'currentyear' => date('Y'),
            'currentmonth' => date('m'),
            'monthsarray' => af_get_months_array(),
        );
    }

    protected function load_resources() {
        wp_enqueue_style('af2_dashboard_style');
        wp_enqueue_script('af2_chart_js');
        wp_enqueue_script('af2_dashboard');
        parent::load_resources();
    }

    public function reset_statistics($month, $year) {
        $old_impressions = get_option('af2_impressions');

        $impression_year = intval($month);
        $impression_month = intval($year);
        
        $full_impression_data = unserialize(get_option('af2_impressions_data'));

        $full_impression_data[$impression_year][$impression_month] = $old_impressions;
        
        update_option('af2_impressions_data', serialize($full_impression_data));
        update_option('af2_impressions', 0);
        update_option('af2_reset_dashboard_date', date('Y-m-d H:i:s', time()));
    }
}