<?php

require_once AF2_MENU_PARENTS_CLASS;
class Af2Checklist extends Af2MenuCustom {

    protected function get_heading() { return 'First steps'; }
    protected function get_menu_custom_template() { return AF2_CUSTOM_MENU_CHECKLIST; }

    protected function get_af2_custom_contents_() { 
        
        $this->check_checklist_options();
        return array(
            array( 'label' => __('Create the necessary questions for your first Funnelform', 'af2_multilanguage'), 'success' => get_option('checklist_question') == 'true' ? true : false, 'url' => admin_url('/admin.php?page='.FRAGE_SLUG.'&action=af2CreatePost&custom_post_type='.FRAGE_POST_TYPE.'&redirect_slug='.FRAGENBUILDER_SLUG ) ),
            array( 'label' => __('Create a contact form to collect the most important personal informations of your leads'), 'af2_multilanguage', 'success' => get_option('checklist_contactform') == 'true' ? true : false, 'url' => admin_url('/admin.php?page='.KONTAKTFORMULAR_SLUG.'&action=af2CreatePost&custom_post_type='.KONTAKTFORMULAR_POST_TYPE.'&redirect_slug='.KONTAKTFORMULARBUILDER_SLUG ) ),
            array( 'label' => __('Create your first Funnelform by linking all questions and contact forms in the form editor'), 'af2_multilanguage', 'success' => get_option('checklist_form') == 'true' ? true : false, 'url' => admin_url('/admin.php?page='.FORMULAR_SLUG.'&action=af2CreatePost&custom_post_type='.FORMULAR_POST_TYPE.'&redirect_slug='.FORMULARBUILDER_SLUG ) ),
            array( 'label' => __('Copy the shortcode and embed the form on your website', 'af2_multilanguage'), 'success' => get_option('checklist_shortcode') == 'true' ? true : false, 'url' => admin_url('/admin.php?page='.FORMULAR_SLUG ) ),
            array( 'label' => __('Create a appointment event and connect your calendar with Funnelforms', 'af2_multilanguage'), 'success' => get_option('checklist_appointmentevent') == 'true' ? true : false, 'url' => admin_url('/admin.php?page='.TERMINEVENT_SLUG.'&action=af2CreatePost&custom_post_type='.TERMINEVENT_POST_TYPE.'&redirect_slug='.TERMINEVENTBUILDER_SLUG ) ),
            array( 'label' => __('Create an appointment booking question and link the appointment event', 'af2_multilanguage'), 'success' => get_option('checklist_appointmenteventquestion') == 'true' ? true : false, 'url' => admin_url('/admin.php?page='.FRAGE_SLUG.'&action=af2CreatePost&custom_post_type='.FRAGE_POST_TYPE.'&redirect_slug='.FRAGENBUILDER_SLUG ) ),
            array( 'label' => __('Add your appointment booking question to your Funnelform', 'af2_multilanguage'), 'success' => get_option('checklist_appointtoform') == 'true' ? true : false, 'url' => admin_url('/admin.php?page='.FORMULAR_SLUG ) ),
        );
    }

    protected function load_resources() {
        wp_enqueue_style('af2_checklist_style');

        parent::load_resources();
    }

    private function check_checklist_options() {
        require_once AF2_MISC_FUNCTIONS_PATH;

        if(get_option('checklist_question') == 'true') {}
        else {
            $posts = $this->Admin->af2_get_posts(FRAGE_POST_TYPE);
            foreach($posts as $post) {
                update_option('checklist_question', 'true');
            }
        }

        if(get_option('checklist_contactform') == 'true') {}
        else {
            $posts = $this->Admin->af2_get_posts(KONTAKTFORMULAR_POST_TYPE);
            foreach($posts as $post) {
                update_option('checklist_contactform', 'true');
            }
        }

        if(get_option('checklist_form') == 'true') {}
        else {
            $posts = $this->Admin->af2_get_posts(FORMULAR_POST_TYPE);
            foreach($posts as $post) {
                update_option('checklist_form', 'true');
            }
        }

        if(get_option('checklist_shortcode') == 'true') {}
        else {
            // Done in frontend.php
        }

        if(get_option('checklist_appointmentevent')== 'true') {}
        else {
            $posts = $this->Admin->af2_get_posts(TERMINEVENT_POST_TYPE);
            foreach($posts as $post) {
                update_option('checklist_appointmentevent', 'true');
            }
        }

        if(get_option('checklist_appointmenteventquestion') == 'true') {}
        else {
            $posts = $this->Admin->af2_get_posts(FRAGE_POST_TYPE);
            foreach($posts as $post) {
                $post_content = af2_get_post_content($post);
                if($post_content['typ'] == 'af2_terminbuchung') update_option('checklist_appointmenteventquestion', 'true');
            }
        }

        if(get_option('checklist_appointtoform') == 'true') {}
        else {
            $posts = $this->Admin->af2_get_posts(FORMULAR_POST_TYPE);
            $frage_posts = $this->Admin->af2_get_posts(FRAGE_POST_TYPE);

            $frage_ids = array();
            foreach($frage_posts as $post) {
                $post_content = af2_get_post_content($post);
                $typ = isset($post_content['typ']) ? $post_content['typ'] : '';
                if($typ == 'af2_terminbuchung') array_push($frage_ids, get_post_field('ID', $post));
            }

            foreach($posts as $post) {
                $post_content = af2_get_post_content($post);
                
                if(isset($post_content['sections'])) {
                    foreach($post_content['sections'] as $section) {
                        if(isset($section['contents'])) {
                            foreach($section['contents'] as $content) {
                                if(in_array($content['data'], $frage_ids)) update_option('checklist_appointtoform', 'true');
                            }
                        }
                    }
                }
            }
        }
    }
}