<?php 

class Af2MenuAjax {

    private $testmail_ajax = null;
    private $dashboard_ajax = null;
    private $import_ajax = null;
    private $demoimport_ajax = null;
    private $lizenz_ajax = null;
    private $integration_ajax = null;
    private $external_ajax = null;
    private $category_ajax = null;

    private $Admin = null;

    function __construct($Admin) {

        $this->Admin = $Admin;

        require_once AF2_MENU_AJAX_TESTMAIL;
        $this->testmail_ajax = new Af2AjaxTestmail();

        require_once AF2_MENU_AJAX_DASHBOARD;
        $this->dashboard_ajax = new Af2AjaxDashboard($Admin);

        require_once AF2_MENU_AJAX_IMPORT;
        $this->import_ajax = new Af2AjaxImport($Admin);

        require_once AF2_MENU_AJAX_DEMOIMPORT;
        $this->demoimport_ajax = new Af2AjaxDemoImport($Admin);

        require_once AF2_MENU_AJAX_LIZENZ;
        $this->lizenz_ajax = new Af2AjaxLizenz();

        require_once AF2_MENU_AJAX_INTEGRATION;
        $this->integration_ajax = new Af2AjaxIntegration();

        require_once AF2_MENU_AJAX_EXTERNAL;
        $this->external_ajax = new Af2AjaxExternal();

        require_once AF2_MENU_AJAX_CATEGORY;
        $this->category_ajax = new Af2AjaxCategory();


        $this->add_actions();
    }

    function add_actions() {
        add_action( 'wp_ajax_af2_trigger_dark_mode', array($this, 'af2_trigger_dark_mode') );
        add_action( 'wp_ajax_af2_save_post', array($this->Admin, 'af2_save_post') );
        add_action( 'wp_ajax_af2_copy_posts', array($this->Admin, 'copy_posts') );
        add_action( 'wp_ajax_af2_delete_posts', array($this->Admin, 'delete_posts') );
        add_action( 'wp_ajax_af2_export', array($this->import_ajax, 'af2_export') );
        add_action( 'wp_ajax_af2_import', array($this->import_ajax, 'af2_import') );
        add_action( 'wp_ajax_af2_demoimport', array($this->demoimport_ajax, 'af2_demoimport') );
        add_action( 'wp_ajax_af2_get_leads_chart', array($this->dashboard_ajax, 'get_leads_chart') );
        add_action( 'wp_ajax_af2_test_mail', array($this->testmail_ajax, 'af2_test_mail') );
        add_action( 'wp_ajax_af2_lizenz_check', array($this->lizenz_ajax, 'af2_do_license_check') );
        add_action( 'wp_ajax_af2_delete_app', array($this->lizenz_ajax, 'af2_delete_app') );
        add_action( 'wp_ajax_af2_save_integration_credentials', array($this->integration_ajax, 'af2_save_integration_credentials') );
        add_action( 'wp_ajax_iframeContent', array( $this->external_ajax, 'iframeContent' ) );
        add_action( 'wp_ajax_nopriv_iframeContent', array( $this->external_ajax, 'iframeContent' ) );
        add_action( 'wp_ajax_af2_add_category', array( $this->category_ajax, 'add_category' ) );
        add_action( 'wp_ajax_af2_delete_category', array( $this->category_ajax, 'delete_category' ) );
        add_action( 'wp_ajax_af2_set_element_category', array( $this->category_ajax, 'update_category' ) );
    }

    // Functions
    function af2_trigger_dark_mode() {
        $state = $_POST['state'];
        $state_number = $state == 'true' ? '1' : '0';
        update_option('af2_dark_mode', $state_number);
        die();
    }
}
    

?>