<?php

function get_kontaktformularbuilder_settings_elements() {
    $editArray = array();

    array_push($editArray, 
        array(
            'editContentId' => 'backend_heading',
            'fields' => array(
                array(
                    'type' => 'textarea_',
                    'icon' => 'fas fa-tag',
                    'label' => __('Contact form title (backend)', 'af2_multilanguage'),
                    'placeholder' => __('Enter title...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_contact_form_backend_heading',
                        'empty_value' => __('Contact form title (backend)', 'af2_multilanguage'),
                        'saveObjectId' => 'name'
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'autoresponder_file',
            'fields' => array(
                array(
                    'type' => 'icon_image',
                    'icon' => 'fas fa-image',
                    'label' => __('File', 'af2_multilanguage'),
                    'label_buttons' => array('image' => __('Select file', 'af2_multilanguage'), 'remove' => __('Delete file', 'af2_multilanguage')),
                    'enable_icon' => false,
                    'enable_media' => true,
                    'enable_remove' => true, 
                    'required' => false,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_autoresponder_file',
                        'icon_url' => true,
                        'empty_value' => __('No file selected', 'af2_multilanguage'),
                        'saveObjectId' => 'attachment_url'
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'redirect_param',
            'editContentArray' => true,
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Parameter name', 'af2_multilanguage'),
                    'placeholder' => __('e.g. firstname', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_redirect_param_text',
                        'empty_value' => __('No parameter set', 'af2_multilanguage'),
                        'saveObjectId' => 'redirect_params',
                        'saveObjectIdField' => 'text'
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Field name from this form', 'af2_multilanguage'),
                    'placeholder' => __('e.g. [firstname]', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_redirect_param_field',
                        'empty_value' => __('No parameter set', 'af2_multilanguage'),
                        'saveObjectId' => 'redirect_params',
                        'saveObjectIdField' => 'field'
                    )
                ),
            ),
        ),
    );


    return $editArray;
}