<?php

function get_kontaktformularbuilder_elements() {
    $editArray = array();

    array_push($editArray, 
        array(
            'editContentId' => 'heading',
            'fields' => array(
                array(
                    'type' => 'textarea_',
                    'icon' => 'fas fa-tag',
                    'label' => __('Contact form title (frontend)', 'af2_multilanguage'),
                    'placeholder' => __('Enter title...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_contact_form_heading',
                        'empty_value' => __('Contact form title (frontend)', 'af2_multilanguage'),
                        'saveObjectId' => 'cftitle'
                    )
                ),
            )
        ),
        array(
            'editContentId' => 'description',
            'fields' => array(
                array(
                    'type' => 'textarea_',
                    'icon' => 'fas fa-tag',
                    'label' => __('Description (optional)', 'af2_multilanguage'),
                    'placeholder' => __('Enter description...', 'af2_multilanguage'),
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_contact_form_description',
                        'empty_value' => __('Description (optional)', 'af2_multilanguage'),
                        'saveObjectId' => 'description'
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'question',
            'editContentArray' => true,
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('ID', 'af2_multilanguage'),
                    'placeholder' => __('Enter ID...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'id'
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Label', 'af2_multilanguage'),
                    'placeholder' => __('Enter label...', 'af2_multilanguage'),
                    'conditioned' => true,
                    'depending_field' => 'typ',
                    'depending_values' => array('salutation_type', 'text_type_name', 'text_type_mail', 'text_type_phone', 'text_type_phone_verification',  'text_type_plain'),
                    'required' => false,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_question_label',
                        'throwEvent' => 'set_required',
                        'empty_value' => '',
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'label'
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Placeholder', 'af2_multilanguage'),
                    'placeholder' => __('Enter placeholder...', 'af2_multilanguage'),
                    'required' => false,
                    'conditioned' => true,
                    'depending_field' => 'typ',
                    'depending_values' => array('text_type_name', 'text_type_mail',  'text_type_plain'),
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_question_input_field',
                        'htmlAttr' => 'placeholder',
                        'throwEvent' => 'set_required',
                        'empty_value' => '',
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'placeholder'
                    )
                ),
                array(
                    'type' => 'textarea_',
                    'icon' => 'fas fa-tag',
                    'label' => __('Text - (do not use "target" for links!)', 'af2_multilanguage'),
                    'placeholder' => __('Enter checkbox text...', 'af2_multilanguage'),
                    'required' => false,
                    'conditioned' => true,
                    'depending_field' => 'typ',
                    'depending_values' => array('checkbox_type'),
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_question_checkbox_text_field',
                        'throwEvent' => 'set_required',
                        'empty_value' => __('Enter checkbox text...', 'af2_multilanguage'),
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'text'
                    )
                ),
                array(
                    'type' => 'icon_image',
                    'icon' => 'fas fa-image',
                    'label' => __('Icon', 'af2_multilanguage'),
                    'label_buttons' => array('icon' => __('Select icon', 'af2_multilanguage'), 'remove' => __('Remove icon', 'af2_multilanguage')),
                    'enable_icon' => true,
                    'enable_media' => false,
                    'enable_remove' => true, 
                    'required' => false,
                    'conditioned' => true,
                    'depending_field' => 'typ',
                    'depending_values' => array('text_type_name', 'text_type_mail', 'text_type_phone', 'text_type_phone_verification',  'text_type_plain'),
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_question_input_icon',
                        'throwEvent' => 'set_icon',
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'icon'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Mr.', 'af2_multilanguage'),
                    'conditioned' => true,
                    'depending_field' => 'typ',
                    'depending_values' => array('salutation_type'),
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_salutation_male',
                        'throwEvent' => 'set_salutation',
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'allowSalutationMale'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Mrs.', 'af2_multilanguage'),
                    'conditioned' => true,
                    'depending_field' => 'typ',
                    'depending_values' => array('salutation_type'),
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_salutation_female',
                        'throwEvent' => 'set_salutation',
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'allowSalutationFemale'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Diverse', 'af2_multilanguage'),
                    'conditioned' => true,
                    'depending_field' => 'typ',
                    'depending_values' => array('salutation_type'),
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_salutation_divers',
                        'throwEvent' => 'set_salutation',
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'allowSalutationDivers'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Company', 'af2_multilanguage'),
                    'conditioned' => true,
                    'depending_field' => 'typ',
                    'depending_values' => array('salutation_type'),
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_salutation_company',
                        'throwEvent' => 'set_salutation',
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'allowSalutationCompany'
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Required field', 'af2_multilanguage'),
                    'conditioned' => true,
                    'depending_field' => 'typ',
                    'depending_values' => array('salutation_type', 'text_type_name', 'text_type_mail', 'text_type_phone',  'text_type_plain', 'checkbox_type'),
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_question_wrapper',
                        'htmlClass' => true,
                        'throwEvent' => 'set_required',
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'required'
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-key',
                    'label' => __('Site key', 'af2_multilanguage'),
                    'placeholder' => __('Enter site key...', 'af2_multilanguage'),
                    'required' => true,
                    'conditioned' => true,
                    'depending_field' => 'typ',
                    'depending_values' => array('google_recaptcha'),
                    'details' => array(
                        'empty_value' => '',
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'site_key'
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-lock',
                    'label' => __('Secret key', 'af2_multilanguage'),
                    'placeholder' => __('Enter secret key...', 'af2_multilanguage'),
                    'required' => true,
                    'conditioned' => true,
                    'depending_field' => 'typ',
                    'depending_values' => array('google_recaptcha'),
                    'details' => array(
                        'empty_value' => '',
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'site_secret'
                    )
                ),
                array(
                    'type' => 'textarea',
                    'icon' => 'fas fa-code',
                    'label' => __('HTML content', 'af2_multilanguage'),
                    'placeholder' => __('Enter HTML content...', 'af2_multilanguage'),
                    'conditioned' => true,
                    'depending_field' => 'typ',
                    'depending_values' => array('html_content'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_html',
                        'empty_value' => __('Enter your HTML content here', 'af2_multilanguage'),
                        'saveObjectId' => 'questions',
                        'saveObjectIdField' => 'html_content',
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'send_button',
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Button text', 'af2_multilanguage'),
                    'placeholder' => __('Enter button text...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => true,
                        'htmlId' => 'af2_contact_form_send_button',
                        'empty_value' => __('Button text', 'af2_multilanguage'),
                        'saveObjectId' => 'send_button'
                    )
                ),
            ),
        ),
    );


    return $editArray;
}
