<?php

function get_formularbuilder_settings_elements() {
    $editArray = array();

    array_push($editArray,
        array(
            'editContentId' => 'general_settings',
            'fields' => array(
                array(
                    'type' => 'textarea_',
                    'icon' => 'fas fa-tag',
                    'label' => __('Form title (backend)', 'af2_multilanguage'),
                    'placeholder' => __('Enter form title...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'saveObjectId' => 'name'
                    )
                ),
                array(
                    'type' => 'textarea_',
                    'icon' => 'fas fa-tag',
                    'label' => __('Form title (frontend)', 'af2_multilanguage'),
                    'placeholder' => __('Enter form title...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'fe_title'
                    ),
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Match form width to the container width', 'af2_multilanguage'),
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'adjust_containersize',
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Loading animation', 'af2_multilanguage'),
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'showLoading',
                    )
                ),
                array(
                    'type' => 'select',
                    'icon' => 'fas fa-language',
                    'label' => __('Form language', 'af2_multilanguage'),
                    'select_values' => array(
                        array('value' => 'default', 'label' => __('WordPress language', 'af2_multilanguage')),
                        array('value' => 'de_DE', 'label' => __('German', 'af2_multilanguage')),
                        array('value' => 'es_ES', 'label' => __('Spanish', 'af2_multilanguage')),
                        array('value' => 'en_US', 'label' => __('English', 'af2_multilanguage')),
                        array('value' => 'fr_FR', 'label' => __('French', 'af2_multilanguage')),
                        array('value' => 'it_IT', 'label' => __('Italian', 'af2_multilanguage')),
                    ),
                    'default_value' => 'Montserrat',
                    'details' => array(
                        'saveObjectId' => 'fe_locale',
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Right-to-left Language', 'af2_multilanguage'),
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'rtl_layout',
                    )
                ),
                /*
                array(
                    'type' => 'checkbox',
                    'label' => __('FontAwesome Icons', 'af2_multilanguage'),
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'showFontAwesome',
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('E-mail notification in case of error', 'af2_multilanguage'),
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'send_error_mail',
                    )
                ),*/
                array(
                    'type' => 'checkbox',
                    'label' => __('Automatic scroll to form title (mobile)', 'af2_multilanguage'),
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'activateScrollToAnchor',
                    )
                ),
                array(
                    'type' => 'checkbox',
                    'label' => __('Show form sent success message', 'af2_multilanguage'),
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'showSuccessScreen',
                    )
                ),
                array(
                    'type' => 'textarea_',
                    'icon' => 'fas fa-tag',
                    'label' => __('Form sent - success message', 'af2_multilanguage'),
                    'placeholder' => __('Enter success message...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'success_text'
                    )
                ),
                array(
                    'type' => 'icon_image',
                    'icon' => 'fas fa-image',
                    'label' => __('Form sent - image', 'af2_multilanguage'),
                    'label_buttons' => array('image' => __('Choose image', 'af2_multilanguage'), 'reset' => __('Reset', 'af2_multilanguage')),
                    'enable_icon' => false,
                    'enable_media' => true,
                    'enable_remove' => false,
                    'enable_reset' => true,
                    'reset_value' => plugins_url('/res/images/success_standard.png', AF2_PLUGIN),
                    'show_preview' => true, 
                    'required' => false,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'success_image',
                    )
                ),
            )
        ),
        array(
            'editContentId' => 'desgin_settings',
            'fields' => array(
                array(
                    'type' => 'color_picker',
                    'label' => __('Main accent color', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'global_main_color',
                        'saveObjectIdSpreadFields' => array(
                            'form_answer_card_icon_color',
                            'form_border_color',
                            'form_box_shadow_color',
                            'form_button_background_color',
                            'form_contact_form_button_background_color',
                            'form_datepicker_background_color',
                            'form_heading_color',
                            'form_loader_color',
                            'form_progress_bar_color',
                            'form_slider_frage_bullet_color',
                            'form_slider_frage_thumb_background_color',
                        )
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Main background color', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'global_main_background_color',
                        'saveObjectIdSpreadFields' => array(
                            'form_background_color'
                        )
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Button text previous step', 'af2_multilanguage'),
                    'placeholder' => __('Enter button text...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'global_prev_text',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-tag',
                    'label' => __('Button text next step', 'af2_multilanguage'),
                    'placeholder' => __('Enter button text...', 'af2_multilanguage'),
                    'required' => false,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'global_next_text',
                    )
                ),
                array(
                    'type' => 'select',
                    'icon' => 'fas fa-pen',
                    'label' => __('Font family', 'af2_multilanguage'),
                    'select_values' => array(
                        array('value' => 'Montserrat', 'label' => __('Default (Montserrat)', 'af2_multilanguage')),
                        array('value' => 'inherit', 'label' => __('Theme-based', 'af2_multilanguage')),
                        array('value' => 'serif', 'label' => __('Serif', 'af2_multilanguage')),
                        array('value' => 'sans-serif', 'label' => __('Sans-Serif', 'af2_multilanguage')),
                        array('value' => 'cursive', 'label' => __('Cursive', 'af2_multilanguage')),
                        array('value' => 'fantasy', 'label' => __('Fantasy', 'af2_multilanguage')),
                        array('value' => 'monospace', 'label' => __('Monospace', 'af2_multilanguage')),
                    ),
                    'default_value' => 'Montserrat',
                    'details' => array(
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'global_font',
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'individual_colors',
            'fields' => array(
                array(
                    'type' => 'color_picker',
                    'label' => __('Form heading', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_heading_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Question heading', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_question_heading_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Question description', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_question_description_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Answer text', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_answer_card_text_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Answer icon', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_answer_card_icon_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Loading animation', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_loader_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Form background', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_background_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Answer background', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_answer_card_background_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Button active', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_button_background_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Button inactive', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_button_disabled_background_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Shadow text-fields', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_box_shadow_color_unfocus',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Shadow text-fields (active)', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_box_shadow_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Shadow selection-fields', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_box_shadow_color_answer_card',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Border', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_border_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Progressbar filled', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_progress_bar_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Progressbar unfilled', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_progress_bar_unfilled_background_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Slider numbers', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_slider_frage_bullet_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Slider selection', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_slider_frage_thumb_background_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Slider background', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_slider_frage_background_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Text row background', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_input_background_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Date background', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_datepicker_background_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Date', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_datepicker_color',
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'font_sizes',
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Headline desktop font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_heading_size_desktop',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Headline mobile font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_heading_size_mobile',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Headline font weight', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_heading_weight',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Headline desktop line height', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_heading_line_height_desktop',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Headline mobile line height', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_heading_line_height_mobile',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Question title desktop font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_question_heading_size_desktop',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Question title mobile font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_question_heading_size_mobile',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Question title font weight', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_question_heading_weight',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Question title desktop line height', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_question_heading_line_height_desktop',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Question title mobile line height', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_question_heading_line_height_mobile',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Answer text desktop font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_answer_card_text_size_desktop',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Answer text mobile font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_answer_card_text_size_mobile',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Answer text font weight', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_answer_card_text_weight',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Answer text desktop line height', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_answer_card_text_line_height_desktop',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Answer text mobile line height', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_answer_card_text_line_height_mobile',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Text row desktop font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_text_input_size_desktop',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Text row mobile font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_text_input_size_mobile',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Text row font weight', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_text_input_text_weight',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Text row desktop line height', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_text_input_line_height_desktop',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Text row mobile line height', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_text_input_line_height_mobile',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Question description desktop font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_question_description_size_desktop',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Question description mobile font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_question_description_size_mobile',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Question description font weight', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_question_description_weight',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Question description desktop line height', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_question_description_line_height_desktop',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Question description mobile line height', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_question_description_line_height_mobile',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Button text desktop font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_button_label_size_desktop',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Button text mobile font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_button_label_size_mobile',
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'border_radius',
            'fields' => array(
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Grid border radius', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_answer_card_border_radius',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Input field border radius', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_text_input_border_radius',
                    )
                ),
            ),
        ),
        array(
            'editContentId' => 'contact_form',
            'fields' => array(
                array(
                    'type' => 'color_picker',
                    'label' => __('Button color', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_button_background_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Button text color', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_button_color',
                    )
                ),
                array(
                    'type' => 'color_picker',
                    'label' => __('Font color', 'af2_multilanguage'),
                    'icon' => 'fas fa-palette',
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_font_color',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Button text font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_button_size',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Button text font weight', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_button_weight',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Button padding top and bottom', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_button_padding_top_bottom',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Button padding left and right', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_button_padding_left_right',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Button border radius', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_button_border_radius',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Label font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_label_size',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Label font weight', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_label_weight',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Text row font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_input_size',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Text row font weight', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_input_weight',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Checkbox text font size', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_cb_size',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Checkbox text font weight', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_cb_weight',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Text row height', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_input_height',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Text row border radius', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_input_border_radius',
                    )
                ),
                array(
                    'type' => 'text',
                    'icon' => 'fas fa-text-height',
                    'label' => __('Input field padding left and right', 'af2_multilanguage'),
                    'placeholder' => __('Enter value...', 'af2_multilanguage'),
                    'required' => true,
                    'details' => array(
                        'html' => false,
                        'saveObjectId' => 'styling',
                        'saveObjectIdField' => 'form_contact_form_input_padding_left_right',
                    )
                ),
            ),
        ),
    );


    return $editArray;
}
