<?php

class Af2AdminHelper {

    public function __construct() {
        add_action('init', array($this, 'af2_menu_get_hooks'));
    }

    public function af2_menu_get_hooks() {
        $action = isset($_GET['action']) ? $_GET['action'] : null;

        switch($action) {
            case 'af2CreatePost': {
                if(!isset($_GET['custom_post_type'])) return;
                if(!isset($_GET['redirect_slug'])) return;
                $empty_array = urlencode(serialize(array("af2_valuable" => true)));
                $post_id = wp_insert_post(array('post_content' => $empty_array, 'post_type' => $_GET['custom_post_type']));

                wp_redirect( admin_url('/admin.php?page='.$_GET['redirect_slug'].'&id='.$post_id ) );
                exit;
                break;
            }
            case 'af2LoadPost': {
                if(!isset($_GET['post_id'])) return;
                if(!isset($_GET['redirect_slug'])) return;

                wp_redirect( admin_url('/admin.php?page='.$_GET['redirect_slug'].'&id='.$_GET['post_id'] ) );
                exit;
                break;
            }
            case 'reset_dashboard': {
                update_option('af2_impressions', 0);
                update_option('af2_impressions_data', serialize([]));
                update_option('af2_reset_dashboard_date', date('Y-m-d H:i:s', time()));

                $request_posts = $this->af2_get_posts(REQUEST_POST_TYPE, array(), 'ASC', true);
                
                foreach($request_posts as $post) {
                    
                    require_once AF2_MISC_FUNCTIONS_PATH;
                    $post_content = af2_get_post_content($post);
                    
                    $post_content['dashboard_relevant'] = 'not';

                    wp_update_post( array('ID' => get_post_field( 'ID', $post ), 'post_content' => urlencode(serialize($post_content))));
                }
            }
            default: {
                break;
            }
        }

        return;
    }


    public function af2_delete_drafts( $post_type )
    {
        // exception

        if($post_type == REQUEST_POST_TYPE) return;
        $posts = get_posts([
            'post_type' => $post_type,
            'post_status' => 'draft',
            'numberposts' => -1,
            'order'    => 'ASC'
        ]);

        for( $i = 0; $i < sizeof( $posts ); $i++ )
        {
            $id = get_post_field('ID', $posts[$i] );
            wp_delete_post( $id );
        }
    }

    public function af2_get_posts( $post_type, array $parameters = array(), $order = 'ASC', $drafts = false ) {
        $pre_query_config = array(
            'post_type' => $post_type,
            'post_status' => 'privat',
            'numberposts' => -1,
            'order'    => $order
        );
        $query_config = array_merge($pre_query_config, $parameters);
        $posts = get_posts($query_config);
        
        if($drafts) return $posts;

        $all_posts = array();

        foreach($posts as $post) {
            if(get_post_field( 'post_status', $post ) == 'draft') continue;
            array_push($all_posts, $post);
        }

        return $all_posts;
    }

    public function af2_convert_question_type( $question_type ) {
        switch($question_type) {
            case "af2_select": {
                return 'Single selection';
            }
            case "af2_multiselect": {
                return 'Multiple selection';
            }
            case "af2_textfeld": {
                return 'Text row';
            }
            case "af2_textbereich": {
                return 'Text area';
            }
            case "af2_datum": {
                return 'Date';
            }
            case "af2_slider": {
                return 'Slider';
            }
            case "af2_content": {
                return 'HTML content';
            }
            case "af2_dateiupload": {
                return 'File upload';
            }
            case "af2_dropdown": {
                return 'Dropdown';
            }
            case "af2_adressfeld": {
                return 'Address';
            }
            case "af2_terminbuchung": {
                return 'Appointment booking';
            }
            default: {
                return 'Kein Fragetyp';
            }
        }
    }

    public function af2_get_question_type_resource_by_label($label) {
        $val = '';
        switch($label) {
            case 'Single selection': {
                $val = '/res/images/question_types/single_selection.png';
                break;
            }
            case 'Multiple selection': {
                $val = '/res/images/question_types/multiple_selection.png';
                break;
            }
            case 'Text row': {
                $val = '/res/images/question_types/text_row.png';
                break;
            }
            case 'Text area': {
                $val = '/res/images/question_types/text_area.png';
                break;
            }
            case 'Date': {
                $val = '/res/images/question_types/date.png';
                break;
            }
            case 'Slider': {
                $val = '/res/images/question_types/slider.png';
                break;
            }
            case 'HTML content': {
                $val = '/res/images/question_types/html.png';
                break;
            }
            case 'File upload': {
                $val = '/res/images/question_types/file_upload.png';
                break;
            }
            case 'Dropdown': {
                $val = '/res/images/question_types/dropdown.png';
                break;
            }
            case 'Address': {
                $val = '/res/images/question_types/address.png';
                break;
            }
            case 'Appointment booking': {
                $val = '/res/images/question_types/appointment_booking.png';
                break;
            }
            default: {
                break;
            }
        }

        return $val;
    }

    public function af2_read_template( $template, $param ) {
        ob_start();
        include $template;
        return ob_get_clean();
    }

    public function convert_datestring_to_array($date) {
        $date = strtotime($date);
        $year = date('Y', $date);
        $month = date('m', $date);
        $day = date('d', $date);
        $hour = date('H', $date);
        $minute = date('i', $date);
        $second = date('s', $date);

        return array(
            'year' => $year,
            'month' => $month,
            'day' => $day,
            'hour' => $hour,
            'minute' => $minute,
            'second' => $second,
        );
    }

    
    public function af2_save_post() {

        $obj = $_POST;
        if(isset($_POST['json'])) {
            $obj = json_decode(stripslashes($_POST['json']), true);
        }

        if(isset($obj['post_id']) && isset($obj['content'])) {

            $post_content = $obj['content'];
            $post_content['af2_valuable'] = null;
            switch($obj['page']) {
                case FRAGENBUILDER_SLUG: { $post_content = Af2Fragenbuilder::save_function($obj['content']); break; }
                case KONTAKTFORMULARBUILDER_SLUG: { $post_content = Af2Kontaktformularbuilder::save_function($obj['content']); break; }
                case KONTAKTFORMULARBUILDER_SETTINGS_SLUG: { $post_content = Af2KontaktformularbuilderSettings::save_function($obj['content']); break; }
                case FORMULARBUILDER_SLUG: {
                    $post_content = Af2Formularbuilder::save_function($obj['content']);
                    break;
                }
                case FORMULARBUILDER_SETTINGS_SLUG: { $post_content = Af2FormularbuilderSettings::save_function($obj['content']); break; }
                case TERMINEVENTBUILDER_SLUG: { $post_content = Af2Termineventbuilder::save_function($obj['content']); break; }
                default: {
                    break;
                }
            }

            wp_update_post(array('ID' => $obj['post_id'], 'post_status' => 'privat', 'post_title' => '', 'post_content' => urlencode(serialize($post_content))));
        }

        die();
    }

    public function copy_posts() {
        if( isset($_POST['post_ids']) && is_array($_POST['post_ids'])) {
            foreach($_POST['post_ids'] as $post_id) {
                $content = get_post_field( 'post_content', $post_id );
                $title = get_post_field( 'post_title', $post_id );
                $type = get_post_field( 'post_type', $post_id );

                $post_content_array = unserialize(urldecode($content));

                if($type == TERMINEVENT_POST_TYPE) {
                    $post_content_array['title'] = $post_content_array['title'].' - '.__('Copy', 'af2_multilanguage');
                }
                else if($type == FRAGE_POST_TYPE || $type == KONTAKTFORMULAR_POST_TYPE || $type == FORMULAR_POST_TYPE){
                    $post_content_array['name'] = $post_content_array['name'].' - '.__('Copy', 'af2_multilanguage');
                }

                $content = urlencode(serialize($post_content_array));

                wp_insert_post( array('post_title' => $title, 'post_content' => $content, 'post_status' => 'privat', 'post_type' => $type) );
            }
        }
        die();
    }

    public function delete_posts() {
        if( isset($_POST['post_ids']) && is_array($_POST['post_ids'])) {
            foreach($_POST['post_ids'] as $post_id) wp_delete_post( $post_id );
        }
        die();
    }

    
}