<?php
class WCUF_Email  
{
	public function __construct() 
	{
		
	}
	public function trigger( $links_to_notify_via_mail, $order , $attachment = array()) 
	{
		global $wcuf_order_model, $wcuf_upload_field_model;
		
		$order_id = $order->get_order_number();	
		$billing_email = $wcuf_order_model->get_billing_email($order) ;	
		foreach($links_to_notify_via_mail as $recipients => $meta)
		{
			$recipient = $recipients;
			$subject = apply_filters('wcuf_email_notification_subject', esc_html__('User submitted new upload for order number: ', 'woocommerce-files-upload').$order_id, $order);
			
			$content = esc_html__('User submitted new upload for order number: ', 'woocommerce-files-upload').'<a href="'.admin_url('post.php?post='.$order_id.'&action=edit').'">'.$order_id.'</a>';
			$content .= "<br /> <br />";
			$content .= "<strong>".esc_html__('Customer personal data', 'woocommerce-files-upload')."</strong><br/>".$order->get_formatted_billing_full_name()." (". $billing_email.") <br/>".$order->get_formatted_billing_address();
			$content .= "<br /> <br />";
			$content .= "<strong>".esc_html__('Uploaded files', 'woocommerce-files-upload')."</strong> <br />";
			$content .= esc_html__('You can directly download by clicking on following links: ', 'woocommerce-files-upload');
			$content .= "<br /> ";
			$content .= '<table>';
			$counter = 0;
			foreach($meta['file_info'] as $download)
			{
				$counter = 0;
				if(isset($download['url']) && is_array($download['url']))
					foreach($download['url'] as $file_url)
					{
						//if($download['source'][$counter] == 'local')
							if(isset($download['title']))
								$content .='<tr><a href="'. $file_url.'">'.$download['title'].": ".$download['file_name'][$counter].'</a> '.esc_html__('(Quantity: ', 'woocommerce-files-upload').$download['quantity'][$counter].')<br/><br/></tr>';
							else
								$content .='<tr><a href="'. $file_url.'">'.$download['title'].'</a> '.esc_html__('(Quantity: ', 'woocommerce-files-upload').$download['quantity'][$counter].')<br/><br/></tr>';
						$counter++;
					}
				if(isset($download['feedback']) && $download['feedback'] != '')
				{
					$content .= '<tr><strong>'.esc_html__('User feedback: ', 'woocommerce-files-upload').'</strong>';
					$content .= "<br /> ";
					$content .= $download['feedback'];
					$content .= "</tr>";
					$content .= "<tr><br/></tr>";
				}
			}
			$content .= '</table>';
			if($wcuf_upload_field_model->can_be_zip_file_created_upload_field_content($meta['order_meta']))
				$content .= '<br/><a href="'.get_site_url().'?wcuf_create_zip_for_field='.$meta['order_meta']['id'].'&wcuf_order_id='.$order_id.'" a>'.esc_html__('Download as zip', 'woocommerce-files-upload').'</a>';
			
			$attachments = isset($attachment[$recipients]) ? $attachment[$recipients] : array();
			$attachments_local = array();
			foreach($attachments as $attachment)
			{
				$counter = 0;
				if(isset($attachment['paths']) && is_array($attachment['paths']))
					foreach($attachment['paths'] as $file_to_attach)
						if($attachment['sources'][$counter++] == 'local')
							$attachments_local[] = $file_to_attach;
			}
			
			$mail = WC()->mailer();
			$email_heading = get_bloginfo('name');
			
			ob_start();
			$mail->email_header($email_heading, $mail);
			echo apply_filters('wcuf_notification_email_content', $content, $order, $attachments);
			$mail->email_footer($mail);
			$message =  ob_get_contents();
			ob_end_clean(); 
			
			
			$mail->send( $recipient, $subject, $message, "Content-Type: text/html\r\n", $attachments_local);
		}
	}
	function send_error_email_to_admin($text)
	{
		$mail = WC()->mailer();
		$email_heading = get_bloginfo('name');
		$subject = esc_html__('Something needs your attention...', 'woocommerce-files-upload');
		
		ob_start();
		$mail->email_header($email_heading, $mail );
		wcuf_html_escape_allowing_special_tags('<h2>The following error has been generated by your site:</h2>');
		echo "<p>".$text."</p>";
		wcuf_html_escape_allowing_special_tags('<p>Be sure that the <strong>max_execution_time</strong> PHP setting is properly setted. For large files execution time may excede the configured time. So in case you are handling big file, try increase that setting.</p>');
		$mail->email_footer($mail);
		$message =  ob_get_contents();
		ob_end_clean(); 
		
		$mail->send( get_bloginfo('admin_email'), $subject, $message, "Content-Type: text/html\r\n");
	}
	function send_approval_status_change_notification($order_id)
	{
		global $wcuf_order_model;
		$order = wc_get_order($order_id);
		if(!$order)
			return;
		$mail = WC()->mailer();
		$email_heading = get_bloginfo('name');
		$subject = sprintf(esc_html__('Order #%s has been updated', 'woocommerce-files-upload'), $order_id);
		$content = sprintf(wcuf_html_escape_allowing_special_tags("Please check <a href='%s'>Order #%s</a>. The status of some files has been changed.", false),$wcuf_order_model->get_order_details_page_url($order), $order->get_order_number());
		$recipients = $order->get_billing_email();
		
		$message = $mail->wrap_message($email_heading, stripcslashes($content));
		
		$attachments =  array();
		if(!$mail->send( $recipients, $subject, $message, "Content-Type: text/html\r\n", $attachments)) 
			wp_mail( $recipients, $subject, $message, "Content-Type: text/html\r\n", $attachments);
		
	}
} 