<?php
/*
 *  Copyright (c) 2024 Borlabs GmbH. All rights reserved.
 *  This file may not be redistributed in whole or significant part.
 *  Content of this file is protected by international copyright laws.
 *
 *  ----------------- Borlabs Cookie IS NOT FREE SOFTWARE -----------------
 *
 *  @copyright Borlabs GmbH, https://borlabs.io
 */

declare(strict_types=1);

namespace Borlabs\Cookie\System\CompatibilityPatch;

use Borlabs\Cookie\Adapter\WpFunction;

final class CompatibilityPatchScriptModifier
{
    private WpFunction $wpFunction;

    public function __construct(
        WpFunction $wpFunction
    ) {
        $this->wpFunction = $wpFunction;
    }

    public function modifyScript(string $script, ?string $compatibilityPatchKey = null): string
    {
        $script = $this->wpFunction->applyFilter(
            'borlabsCookie/compatibilityPatch/modifyScript/',
            $script,
        );

        if ($compatibilityPatchKey) {
            $script = $this->wpFunction->applyFilter(
                'borlabsCookie/compatibilityPatch/modifyScript/' . $compatibilityPatchKey,
                $script,
            );
        }

        return $script;
    }
}
